/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.track;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import mods.railcraft.api.charge.Charge;
import mods.railcraft.api.charge.ChargeBlock;
import mods.railcraft.api.item.SpikeMaulTarget;
import mods.railcraft.api.track.TrackType;
import mods.railcraft.api.track.TrackUtil;
import mods.railcraft.api.track.TypedTrack;
import mods.railcraft.world.item.SpikeMaulItem;
import mods.railcraft.world.level.block.track.RailcraftState;
import mods.railcraft.world.level.block.track.behaivor.TrackSupportTools;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class TrackBlock
extends BaseRailBlock
implements TypedTrack,
ChargeBlock,
SpikeMaulTarget {
    public static final EnumProperty<RailShape> SHAPE = BlockStateProperties.f_61403_;
    private static final Map<Charge, ChargeBlock.Spec> CHARGE_SPECS = ChargeBlock.Spec.make(Charge.distribution, ChargeBlock.ConnectType.TRACK, 0.01f);
    private final Supplier<? extends TrackType> trackType;

    public TrackBlock(Supplier<? extends TrackType> trackType, BlockBehaviour.Properties properties) {
        super(false, properties);
        this.trackType = trackType;
        this.m_49959_(this.buildDefaultState((BlockState)this.f_49792_.m_61090_()));
    }

    @Override
    public TrackType getTrackType() {
        return this.trackType.get();
    }

    public Property<RailShape> m_7978_() {
        return SHAPE;
    }

    protected BlockState buildDefaultState(BlockState blockState) {
        return (BlockState)((BlockState)blockState.m_61124_(this.m_7978_(), (Comparable)RailShape.NORTH_SOUTH)).m_61124_((Property)f_152149_, (Comparable)Boolean.valueOf(false));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{this.m_7978_(), f_152149_});
    }

    @Override
    public List<? extends Supplier<? extends Block>> getSpikeMaulVariants() {
        return this.trackType.get().getSpikeMaulVariants();
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        super.m_213897_(state, level, pos, random);
        if (this.getTrackType().isElectric()) {
            this.registerNode(state, level, pos);
        }
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource rand) {
        if (this.getTrackType().isElectric()) {
            Charge.zapEffectProvider().throwSparks(state, level, pos, rand, 75);
        }
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext context) {
        if (context.m_43722_().m_41720_() instanceof SpikeMaulItem) {
            return true;
        }
        return super.m_6864_(state, context);
    }

    public void m_6807_(BlockState blockState, Level level, BlockPos pos, BlockState oldBlockState, boolean moved) {
        super.m_6807_(blockState, level, pos, oldBlockState, moved);
        if (!blockState.m_60713_(oldBlockState.m_60734_())) {
            if (!TrackSupportTools.isSupported((LevelReader)level, pos, this.getMaxSupportedDistance())) {
                level.m_46961_(pos, true);
                return;
            }
            if (this.getTrackType().isElectric()) {
                this.registerNode(blockState, (ServerLevel)level, pos);
            }
        }
    }

    public BlockState m_49367_(Level level, BlockPos pos, BlockState state, boolean alwaysPlace) {
        if (level.f_46443_) {
            return state;
        }
        RailShape railshape = (RailShape)state.m_61143_(this.m_7978_());
        return new RailcraftState(level, pos, state).place(level.m_276867_(pos), alwaysPlace, railshape).getState();
    }

    public void m_6810_(BlockState blockState, Level level, BlockPos pos, BlockState newBlockState, boolean moved) {
        super.m_6810_(blockState, level, pos, newBlockState, moved);
        if (this.getTrackType().isElectric() && !blockState.m_60713_(newBlockState.m_60734_())) {
            this.deregisterNode((ServerLevel)level, pos);
        }
    }

    @Override
    public Map<Charge, ChargeBlock.Spec> getChargeSpecs(BlockState state, ServerLevel level, BlockPos pos) {
        return this.getTrackType().isElectric() ? CHARGE_SPECS : Collections.emptyMap();
    }

    public int getMaxSupportedDistance() {
        return this.getTrackType().getMaxSupportDistance();
    }

    protected boolean isRailValid(BlockState state, Level level, BlockPos pos, int maxSupportedDistance) {
        RailShape railShape = TrackUtil.getRailShapeRaw(state);
        if (!TrackSupportTools.isSupported((LevelReader)level, pos, maxSupportedDistance)) {
            return false;
        }
        if (maxSupportedDistance == 0) {
            if (railShape == RailShape.ASCENDING_EAST && !TrackBlock.m_49936_((BlockGetter)level, (BlockPos)pos.m_122029_())) {
                return false;
            }
            if (railShape == RailShape.ASCENDING_WEST && !TrackBlock.m_49936_((BlockGetter)level, (BlockPos)pos.m_122024_())) {
                return false;
            }
            if (railShape == RailShape.ASCENDING_NORTH && !TrackBlock.m_49936_((BlockGetter)level, (BlockPos)pos.m_122012_())) {
                return false;
            }
            if (railShape == RailShape.ASCENDING_SOUTH && !TrackBlock.m_49936_((BlockGetter)level, (BlockPos)pos.m_122019_())) {
                return false;
            }
        }
        return true;
    }

    public void m_6861_(BlockState blockState, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean moved) {
        if (level.m_5776_()) {
            return;
        }
        if (!this.isRailValid(blockState, level, pos, this.getMaxSupportedDistance())) {
            level.m_46961_(pos, true);
            return;
        }
        this.m_6360_(blockState, level, pos, neighborBlock);
        TrackUtil.traverseConnectedTracks(level, pos, (l, p) -> {
            BlockState state = l.m_8055_(p);
            Block block = state.m_60734_();
            if (!BaseRailBlock.m_49416_((BlockState)state)) {
                return false;
            }
            if (block instanceof TrackBlock) {
                TrackBlock track = (TrackBlock)block;
                int maxSupportedDistance = track.getMaxSupportedDistance();
                if (maxSupportedDistance <= 0 || TrackSupportTools.isSupportedDirectly((BlockGetter)l, p)) {
                    return false;
                }
                if (!track.isRailValid(state, (Level)l, (BlockPos)p, maxSupportedDistance)) {
                    l.m_46961_(p, true);
                    return false;
                }
            }
            return true;
        });
    }

    public void onMinecartPass(BlockState state, Level level, BlockPos pos, AbstractMinecart cart) {
        this.getTrackType().getEventHandler().minecartPass(level, cart, pos);
    }

    public RailShape getRailDirection(BlockState state, BlockGetter blockGetter, BlockPos pos, @Nullable AbstractMinecart cart) {
        return this.getTrackType().getEventHandler().getRailShapeOverride(blockGetter, pos, state, cart).orElseGet(() -> super.getRailDirection(state, blockGetter, pos, cart));
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.getTrackType().getEventHandler().entityInside(serverLevel, pos, state, entity);
        }
    }

    public float getRailMaxSpeed(BlockState state, Level level, BlockPos pos, AbstractMinecart cart) {
        return (float)this.getTrackType().getEventHandler().getMaxSpeed(level, cart, pos);
    }

    public boolean canMakeSlopes(BlockState state, BlockGetter blockGetter, BlockPos pos) {
        return TrackSupportTools.isSupportedDirectly(blockGetter, pos);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return !BaseRailBlock.m_49416_((BlockState)level.m_8055_(pos.m_7494_())) && !BaseRailBlock.m_49416_((BlockState)level.m_8055_(pos.m_7495_())) && TrackSupportTools.isSupported(level, pos, this.getMaxSupportedDistance());
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter level, BlockPos blockPos, CollisionContext context) {
        RailShape railShape = blockState.m_60713_((Block)this) ? (RailShape)blockState.m_61143_(this.m_7978_()) : null;
        return railShape != null && railShape.m_61745_() ? f_49356_ : f_49355_;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        switch (rot) {
            case CLOCKWISE_180: {
                switch ((RailShape)state.m_61143_(this.m_7978_())) {
                    case ASCENDING_EAST: {
                        return (BlockState)state.m_61124_(this.m_7978_(), (Comparable)RailShape.ASCENDING_WEST);
                    }
                    case ASCENDING_WEST: {
                        return (BlockState)state.m_61124_(this.m_7978_(), (Comparable)RailShape.ASCENDING_EAST);
                    }
                    case ASCENDING_NORTH: {
                        return (BlockState)state.m_61124_(this.m_7978_(), (Comparable)RailShape.ASCENDING_SOUTH);
                    }
                    case ASCENDING_SOUTH: {
                        return (BlockState)state.m_61124_(this.m_7978_(), (Comparable)RailShape.ASCENDING_NORTH);
                    }
                    case SOUTH_EAST: {
                        return (BlockState)state.m_61124_(this.m_7978_(), (Comparable)RailShape.NORTH_WEST);
                    }
                    case SOUTH_WEST: {
                        return (BlockState)state.m_61124_(this.m_7978_(), (Comparable)RailShape.NORTH_EAST);
                    }
                    case NORTH_WEST: {
                        return (BlockState)state.m_61124_(this.m_7978_(), (Comparable)RailShape.SOUTH_EAST);
                    }
                    case NORTH_EAST: {
                        return (BlockState)state.m_61124_(this.m_7978_(), (Comparable)RailShape.SOUTH_WEST);
                    }
                    case NORTH_SOUTH: 
                    case EAST_WEST: {
                        return state;
                    }
                }
            }
            case COUNTERCLOCKWISE_90: {
                switch ((RailShape)state.m_61143_(this.m_7978_())) {
                    case ASCENDING_EAST: {
                        return (BlockState)state.m_61124_(this.m_7978_(), (Comparable)RailShape.ASCENDING_NORTH);
                    }
                    case ASCENDING_WEST: {
                        return (BlockState)state.m_61124_(this.m_7978_(), (Comparable)RailShape.ASCENDING_SOUTH);
                    }
                    case ASCENDING_NORTH: {
                        return (BlockState)state.m_61124_(this.m_7978_(), (Comparable)RailShape.ASCENDING_WEST);
                    }
                    case ASCENDING_SOUTH: {
                        return (BlockState)state.m_61124_(this.m_7978_(), (Comparable)RailShape.ASCENDING_EAST);
                    }
                    case SOUTH_EAST: {
                        return (BlockState)state.m_61124_(this.m_7978_(), (Comparable)RailShape.NORTH_EAST);
                    }
                    case SOUTH_WEST: {
                        return (BlockState)state.m_61124_(this.m_7978_(), (Comparable)RailShape.SOUTH_EAST);
                    }
                    case NORTH_WEST: {
                        return (BlockState)state.m_61124_(this.m_7978_(), (Comparable)RailShape.SOUTH_WEST);
                    }
                    case NORTH_EAST: {
                        return (BlockState)state.m_61124_(this.m_7978_(), (Comparable)RailShape.NORTH_WEST);
                    }
                    case NORTH_SOUTH: {
                        return (BlockState)state.m_61124_(this.m_7978_(), (Comparable)RailShape.EAST_WEST);
                    }
                    case EAST_WEST: {
                        return (BlockState)state.m_61124_(this.m_7978_(), (Comparable)RailShape.NORTH_SOUTH);
                    }
                }
            }
            case CLOCKWISE_90: {
                switch ((RailShape)state.m_61143_(this.m_7978_())) {
                    case ASCENDING_EAST: {
                        return (BlockState)state.m_61124_(this.m_7978_(), (Comparable)RailShape.ASCENDING_SOUTH);
                    }
                    case ASCENDING_WEST: {
                        return (BlockState)state.m_61124_(this.m_7978_(), (Comparable)RailShape.ASCENDING_NORTH);
                    }
                    case ASCENDING_NORTH: {
                        return (BlockState)state.m_61124_(this.m_7978_(), (Comparable)RailShape.ASCENDING_EAST);
                    }
                    case ASCENDING_SOUTH: {
                        return (BlockState)state.m_61124_(this.m_7978_(), (Comparable)RailShape.ASCENDING_WEST);
                    }
                    case SOUTH_EAST: {
                        return (BlockState)state.m_61124_(this.m_7978_(), (Comparable)RailShape.SOUTH_WEST);
                    }
                    case SOUTH_WEST: {
                        return (BlockState)state.m_61124_(this.m_7978_(), (Comparable)RailShape.NORTH_WEST);
                    }
                    case NORTH_WEST: {
                        return (BlockState)state.m_61124_(this.m_7978_(), (Comparable)RailShape.NORTH_EAST);
                    }
                    case NORTH_EAST: {
                        return (BlockState)state.m_61124_(this.m_7978_(), (Comparable)RailShape.SOUTH_EAST);
                    }
                    case NORTH_SOUTH: {
                        return (BlockState)state.m_61124_(this.m_7978_(), (Comparable)RailShape.EAST_WEST);
                    }
                    case EAST_WEST: {
                        return (BlockState)state.m_61124_(this.m_7978_(), (Comparable)RailShape.NORTH_SOUTH);
                    }
                }
            }
        }
        return state;
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        Property<RailShape> shape = this.m_7978_();
        RailShape railshape = (RailShape)state.m_61143_(shape);
        block0 : switch (mirror) {
            case LEFT_RIGHT: {
                switch (railshape) {
                    case ASCENDING_NORTH: {
                        return (BlockState)state.m_61124_(shape, (Comparable)RailShape.ASCENDING_SOUTH);
                    }
                    case ASCENDING_SOUTH: {
                        return (BlockState)state.m_61124_(shape, (Comparable)RailShape.ASCENDING_NORTH);
                    }
                    case SOUTH_EAST: {
                        return (BlockState)state.m_61124_(shape, (Comparable)RailShape.NORTH_EAST);
                    }
                    case SOUTH_WEST: {
                        return (BlockState)state.m_61124_(shape, (Comparable)RailShape.NORTH_WEST);
                    }
                    case NORTH_WEST: {
                        return (BlockState)state.m_61124_(shape, (Comparable)RailShape.SOUTH_WEST);
                    }
                    case NORTH_EAST: {
                        return (BlockState)state.m_61124_(shape, (Comparable)RailShape.SOUTH_EAST);
                    }
                }
                return super.m_6943_(state, mirror);
            }
            case FRONT_BACK: {
                switch (railshape) {
                    case ASCENDING_EAST: {
                        return (BlockState)state.m_61124_(shape, (Comparable)RailShape.ASCENDING_WEST);
                    }
                    case ASCENDING_WEST: {
                        return (BlockState)state.m_61124_(shape, (Comparable)RailShape.ASCENDING_EAST);
                    }
                    default: {
                        break block0;
                    }
                    case SOUTH_EAST: {
                        return (BlockState)state.m_61124_(shape, (Comparable)RailShape.SOUTH_WEST);
                    }
                    case SOUTH_WEST: {
                        return (BlockState)state.m_61124_(shape, (Comparable)RailShape.SOUTH_EAST);
                    }
                    case NORTH_WEST: {
                        return (BlockState)state.m_61124_(shape, (Comparable)RailShape.NORTH_EAST);
                    }
                    case NORTH_EAST: 
                }
                return (BlockState)state.m_61124_(shape, (Comparable)RailShape.NORTH_WEST);
            }
        }
        return super.m_6943_(state, mirror);
    }

    public static RailShape getRailShapeRaw(BlockState state) {
        return (RailShape)state.m_61143_(((BaseRailBlock)state.m_60734_()).m_7978_());
    }
}

