/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.track.behaivor;

import java.util.Optional;
import mods.railcraft.RailcraftConfig;
import mods.railcraft.api.carts.RollingStock;
import mods.railcraft.api.track.RailShapeUtil;
import mods.railcraft.api.track.TrackType;
import mods.railcraft.api.track.TrackUtil;
import mods.railcraft.world.entity.vehicle.MinecartUtil;
import mods.railcraft.world.level.block.track.behaivor.HighSpeedTrackUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum SpeedController implements TrackType.EventHandler
{
    IRON,
    ABANDONED{

        @Override
        public double getMaxSpeed(Level level, @Nullable AbstractMinecart cart, BlockPos pos) {
            return 0.36;
        }

        private boolean isDerailing(RollingStock cart) {
            return MinecartUtil.getCartSpeedUncapped(cart.entity().m_20184_()) > (double)0.35f && cart.level().m_213780_().m_188503_(500) == 250 || cart.train().stream().anyMatch(RollingStock::isDerailed);
        }

        @Override
        @Nullable
        public Optional<RailShape> getRailShapeOverride(BlockGetter level, BlockPos pos, BlockState state, @Nullable AbstractMinecart cart) {
            if (cart == null || cart.m_9236_().m_5776_()) {
                return Optional.empty();
            }
            RailShape shape = TrackUtil.getRailShapeRaw(state);
            if (!RailShapeUtil.isLevelStraight(shape)) {
                return Optional.empty();
            }
            RollingStock extension = RollingStock.getOrThrow(cart);
            if (!this.isDerailing(extension)) {
                return Optional.empty();
            }
            extension.setDerailedRemainingTicks(100);
            Vec3 motion = cart.m_20184_();
            if (Math.abs(motion.m_7096_()) > Math.abs(motion.m_7094_())) {
                cart.m_20334_(motion.m_7096_(), motion.m_7098_(), motion.m_7096_());
            } else {
                cart.m_20334_(motion.m_7094_(), motion.m_7098_(), motion.m_7094_());
            }
            return switch (shape) {
                case RailShape.NORTH_SOUTH -> Optional.of(RailShape.EAST_WEST);
                case RailShape.EAST_WEST -> Optional.of(RailShape.NORTH_SOUTH);
                default -> Optional.empty();
            };
        }
    }
    ,
    HIGH_SPEED{

        @Override
        public void minecartPass(Level level, AbstractMinecart cart, BlockPos pos) {
            RollingStock.getOrThrow(cart).checkHighSpeed(pos);
        }

        @Override
        public double getMaxSpeed(Level level, @Nullable AbstractMinecart cart, BlockPos pos) {
            return HighSpeedTrackUtil.getMaxSpeed(level, cart, pos);
        }
    }
    ,
    REINFORCED{

        @Override
        public double getMaxSpeed(Level level, @Nullable AbstractMinecart cart, BlockPos pos) {
            RailShape shape = TrackUtil.getTrackDirection((BlockGetter)level, pos, cart);
            return RailShapeUtil.isTurn(shape) || shape.m_61745_() ? (double)0.4f : (double)0.44f;
        }
    }
    ,
    STRAP_IRON{

        @Override
        public double getMaxSpeed(Level level, @Nullable AbstractMinecart cart, BlockPos pos) {
            return (Double)RailcraftConfig.SERVER.strapIronTrackMaxSpeed.get();
        }
    };

}

