/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.module;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import mods.railcraft.world.module.CrafterModule;
import mods.railcraft.world.module.ModuleProvider;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import org.jetbrains.annotations.Nullable;

public abstract class CookingModule<R extends AbstractCookingRecipe, T extends ModuleProvider>
extends CrafterModule<T> {
    private final int inputSlot;
    @Nullable
    protected R recipe;
    private ItemStack lastInput = ItemStack.f_41583_;

    protected CookingModule(T provider, int size, int inputSlot) {
        super(provider, size);
        this.inputSlot = inputSlot;
    }

    protected abstract RecipeType<R> getRecipeType();

    @Override
    @OverridingMethodsMustInvokeSuper
    protected void setupCrafting() {
        ItemStack input = this.m_8020_(this.inputSlot);
        if (!ItemStack.m_41728_((ItemStack)input, (ItemStack)this.lastInput)) {
            this.lastInput = input.m_41777_();
            this.recipe = this.getRecipeFor(input).orElse(null);
            if (this.recipe == null && !input.m_41619_()) {
                this.m_6836_(this.inputSlot, ItemStack.f_41583_);
                this.provider.dropItem(input);
            }
        }
    }

    protected Optional<R> getRecipeFor(ItemStack itemStack) {
        return this.provider.level().m_7465_().m_44015_(this.getRecipeType(), (Container)new SimpleContainer(new ItemStack[]{itemStack}), this.provider.level());
    }

    @Override
    protected boolean lacksRequirements() {
        return this.recipe == null;
    }

    @Override
    protected final int calculateDuration() {
        Objects.requireNonNull(this.recipe);
        return this.recipe.m_43753_();
    }
}

