/*
 * Decompiled with CFR 0.152.
 */
package com.dremoline.portabletanks;

import com.dremoline.portabletanks.PortableTankBlock;
import com.dremoline.portabletanks.PortableTankBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.render.CustomBlockEntityRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import org.joml.Matrix4f;

public class PortableTankRenderer
implements CustomBlockEntityRenderer<PortableTankBlockEntity> {
    private static final float SIDE_MARGIN = (float)PortableTankBlock.SHAPE.getStart(Direction.Axis.X) + 0.01f;
    private static final float MIN_Y = 0.0625f;
    private static final float MAX_Y = 0.9375f;

    public void render(PortableTankBlockEntity entity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLight, int combinedOverlay) {
        FluidStack fluidStack = entity.getFluidInTank(0);
        if (fluidStack.isEmpty()) {
            return;
        }
        float fillPercentage = Math.min(1.0f, (float)fluidStack.getAmount() / (float)entity.getTankCapacity(0));
        if (fluidStack.getFluid().getFluidType().isLighterThanAir()) {
            PortableTankRenderer.renderFluid(poseStack, bufferSource, fluidStack, fillPercentage, 1.0f, combinedLight);
        } else {
            PortableTankRenderer.renderFluid(poseStack, bufferSource, fluidStack, 1.0f, fillPercentage, combinedLight);
        }
    }

    private static void renderFluid(PoseStack poseStack, MultiBufferSource bufferSource, FluidStack fluidStack, float alpha, float heightPercentage, int combinedLight) {
        VertexConsumer vertexBuilder = bufferSource.m_6299_(RenderType.m_110466_());
        IClientFluidTypeExtensions fluidTypeExtensions = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid());
        TextureAtlasSprite sprite = (TextureAtlasSprite)ClientUtils.getMinecraft().m_91258_(TextureAtlas.f_118259_).apply(fluidTypeExtensions.getStillTexture(fluidStack));
        int color = fluidTypeExtensions.getTintColor();
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        PortableTankRenderer.renderQuads(poseStack.m_85850_().m_252922_(), vertexBuilder, sprite, red, green, blue, alpha *= (float)(color >> 24 & 0xFF) / 255.0f, heightPercentage, combinedLight);
    }

    private static void renderQuads(Matrix4f matrix, VertexConsumer buffer, TextureAtlasSprite sprite, float r, float g, float b, float alpha, float heightPercentage, int light) {
        float height = 0.0625f + 0.875f * heightPercentage;
        float minU = sprite.m_118367_((double)(SIDE_MARGIN * 16.0f));
        float maxU = sprite.m_118367_((double)((1.0f - SIDE_MARGIN) * 16.0f));
        float minV = sprite.m_118393_(1.0);
        float maxV = sprite.m_118393_((double)(height * 16.0f));
        buffer.m_252986_(matrix, SIDE_MARGIN, 0.0625f, SIDE_MARGIN).m_85950_(r, g, b, alpha).m_7421_(minU, minV).m_85969_(light).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        buffer.m_252986_(matrix, SIDE_MARGIN, height, SIDE_MARGIN).m_85950_(r, g, b, alpha).m_7421_(minU, maxV).m_85969_(light).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        buffer.m_252986_(matrix, 1.0f - SIDE_MARGIN, height, SIDE_MARGIN).m_85950_(r, g, b, alpha).m_7421_(maxU, maxV).m_85969_(light).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        buffer.m_252986_(matrix, 1.0f - SIDE_MARGIN, 0.0625f, SIDE_MARGIN).m_85950_(r, g, b, alpha).m_7421_(maxU, minV).m_85969_(light).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        buffer.m_252986_(matrix, SIDE_MARGIN, 0.0625f, 1.0f - SIDE_MARGIN).m_85950_(r, g, b, alpha).m_7421_(minU, minV).m_85969_(light).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        buffer.m_252986_(matrix, 1.0f - SIDE_MARGIN, 0.0625f, 1.0f - SIDE_MARGIN).m_85950_(r, g, b, alpha).m_7421_(maxU, minV).m_85969_(light).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        buffer.m_252986_(matrix, 1.0f - SIDE_MARGIN, height, 1.0f - SIDE_MARGIN).m_85950_(r, g, b, alpha).m_7421_(maxU, maxV).m_85969_(light).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        buffer.m_252986_(matrix, SIDE_MARGIN, height, 1.0f - SIDE_MARGIN).m_85950_(r, g, b, alpha).m_7421_(minU, maxV).m_85969_(light).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        buffer.m_252986_(matrix, SIDE_MARGIN, 0.0625f, SIDE_MARGIN).m_85950_(r, g, b, alpha).m_7421_(minU, minV).m_85969_(light).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix, SIDE_MARGIN, 0.0625f, 1.0f - SIDE_MARGIN).m_85950_(r, g, b, alpha).m_7421_(maxU, minV).m_85969_(light).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix, SIDE_MARGIN, height, 1.0f - SIDE_MARGIN).m_85950_(r, g, b, alpha).m_7421_(maxU, maxV).m_85969_(light).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix, SIDE_MARGIN, height, SIDE_MARGIN).m_85950_(r, g, b, alpha).m_7421_(minU, maxV).m_85969_(light).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix, 1.0f - SIDE_MARGIN, 0.0625f, SIDE_MARGIN).m_85950_(r, g, b, alpha).m_7421_(minU, minV).m_85969_(light).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix, 1.0f - SIDE_MARGIN, height, SIDE_MARGIN).m_85950_(r, g, b, alpha).m_7421_(minU, maxV).m_85969_(light).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix, 1.0f - SIDE_MARGIN, height, 1.0f - SIDE_MARGIN).m_85950_(r, g, b, alpha).m_7421_(maxU, maxV).m_85969_(light).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix, 1.0f - SIDE_MARGIN, 0.0625f, 1.0f - SIDE_MARGIN).m_85950_(r, g, b, alpha).m_7421_(maxU, minV).m_85969_(light).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        if (heightPercentage < 1.0f) {
            minV = sprite.m_118393_((double)(SIDE_MARGIN * 16.0f));
            maxV = sprite.m_118393_((double)((1.0f - SIDE_MARGIN) * 16.0f));
            buffer.m_252986_(matrix, SIDE_MARGIN, height, SIDE_MARGIN).m_85950_(r, g, b, alpha).m_7421_(minU, minV).m_85969_(light).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
            buffer.m_252986_(matrix, SIDE_MARGIN, height, 1.0f - SIDE_MARGIN).m_85950_(r, g, b, alpha).m_7421_(minU, maxV).m_85969_(light).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
            buffer.m_252986_(matrix, 1.0f - SIDE_MARGIN, height, 1.0f - SIDE_MARGIN).m_85950_(r, g, b, alpha).m_7421_(maxU, maxV).m_85969_(light).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
            buffer.m_252986_(matrix, 1.0f - SIDE_MARGIN, height, SIDE_MARGIN).m_85950_(r, g, b, alpha).m_7421_(maxU, minV).m_85969_(light).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        }
    }
}

