/*
 * Decompiled with CFR 0.152.
 */
package com.dremoline.portabletanks.compatibility;

import com.dremoline.portabletanks.PortableTankBlock;
import com.dremoline.portabletanks.PortableTankBlockEntity;
import com.supermartijn642.core.TextComponents;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fluids.FluidStack;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.WailaPlugin;
import snownee.jade.api.config.IPluginConfig;

@WailaPlugin(value="portabletanks")
public class PortableTanksWailaPlugin
implements IWailaPlugin,
IBlockComponentProvider {
    public void registerClient(IWailaClientRegistration registration) {
        registration.registerBlockComponent((IBlockComponentProvider)this, PortableTankBlock.class);
    }

    public void appendTooltip(ITooltip tooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
        BlockEntity entity = blockAccessor.getBlockEntity();
        if (entity instanceof PortableTankBlockEntity) {
            int capacity = ((PortableTankBlockEntity)entity).getTankType().tankCapacity.get();
            FluidStack contents = ((PortableTankBlockEntity)entity).getTankContent();
            MutableComponent capacityText = TextComponents.number((int)capacity).color(ChatFormatting.GOLD).get();
            if (contents.isEmpty()) {
                MutableComponent text = TextComponents.translation((String)"portabletanks.portable_tank.info.capacity", (Object[])new Object[]{capacityText}).get();
                tooltip.add((Component)text);
            } else {
                MutableComponent amountText = TextComponents.number((int)contents.getAmount()).color(ChatFormatting.GOLD).get();
                MutableComponent fluidName = TextComponents.fluidStack((FluidStack)contents).color(ChatFormatting.GOLD).get();
                MutableComponent text = TextComponents.translation((String)"portabletanks.portable_tank.info.stored", (Object[])new Object[]{fluidName, amountText, capacityText}).get();
                tooltip.add((Component)text);
            }
        }
    }

    public ResourceLocation getUid() {
        return new ResourceLocation("portabletanks", "portable_tank_component");
    }
}

