/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.blocks;

import dan200.computercraft.shared.computer.apis.CommandAPI;
import dan200.computercraft.shared.computer.blocks.ComputerBlockEntity;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.config.Config;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class CommandComputerBlockEntity
extends ComputerBlockEntity {
    private final CommandReceiver receiver = new CommandReceiver();

    public CommandComputerBlockEntity(BlockEntityType<? extends ComputerBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state, ComputerFamily.COMMAND);
    }

    public CommandReceiver getReceiver() {
        return this.receiver;
    }

    public CommandSourceStack getSource() {
        String label;
        ServerComputer computer = this.getServerComputer();
        String name = "@";
        if (computer != null && (label = computer.getLabel()) != null) {
            name = label;
        }
        return new CommandSourceStack((CommandSource)this.receiver, Vec3.m_82512_((Vec3i)this.f_58858_), Vec2.f_82462_, (ServerLevel)this.m_58904_(), 2, name, (Component)Component.m_237113_((String)name), this.m_58904_().m_7654_(), null);
    }

    @Override
    protected ServerComputer createComputer(int id) {
        ServerComputer computer = super.createComputer(id);
        computer.addAPI(new CommandAPI(this));
        return computer;
    }

    @Override
    public boolean isUsable(Player player) {
        return CommandComputerBlockEntity.isCommandUsable(player) && super.isUsable(player);
    }

    public static boolean isCommandUsable(Player player) {
        MinecraftServer server = player.m_20194_();
        if (server == null || !server.m_6993_()) {
            player.m_5661_((Component)Component.m_237115_((String)"advMode.notEnabled"), true);
            return false;
        }
        if (!CommandComputerBlockEntity.canUseCommandBlock(player)) {
            player.m_5661_((Component)Component.m_237115_((String)"advMode.notAllowed"), true);
            return false;
        }
        return true;
    }

    private static boolean canUseCommandBlock(Player player) {
        return Config.commandRequireCreative ? player.m_36337_() : player.m_20310_(2);
    }

    public class CommandReceiver
    implements CommandSource {
        private final List<String> output = new ArrayList<String>();

        public void clearOutput() {
            this.output.clear();
        }

        public List<String> copyOutput() {
            return new ArrayList<String>(this.output);
        }

        public void m_213846_(Component textComponent) {
            this.output.add(textComponent.getString());
        }

        public boolean m_6999_() {
            return true;
        }

        public boolean m_7028_() {
            return true;
        }

        public boolean m_6102_() {
            return CommandComputerBlockEntity.this.m_58904_().m_46469_().m_46207_(GameRules.f_46138_);
        }
    }
}

