/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.pocket.apis;

import dan200.computercraft.api.lua.ILuaAPI;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.api.upgrades.UpgradeData;
import dan200.computercraft.impl.PocketUpgrades;
import dan200.computercraft.shared.pocket.core.PocketServerComputer;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class PocketAPI
implements ILuaAPI {
    private final PocketServerComputer computer;

    public PocketAPI(PocketServerComputer computer) {
        this.computer = computer;
    }

    @Override
    public String[] getNames() {
        return new String[]{"pocket"};
    }

    @LuaFunction(mainThread=true)
    public final Object[] equipBack() {
        Entity entity = this.computer.getEntity();
        if (!(entity instanceof Player)) {
            return new Object[]{false, "Cannot find player"};
        }
        Player player = (Player)entity;
        Inventory inventory = player.m_150109_();
        UpgradeData<IPocketUpgrade> previousUpgrade = this.computer.getUpgrade();
        UpgradeData<IPocketUpgrade> newUpgrade = PocketAPI.findUpgrade((NonNullList<ItemStack>)inventory.f_35974_, inventory.f_35977_, previousUpgrade);
        if (newUpgrade == null) {
            newUpgrade = PocketAPI.findUpgrade((NonNullList<ItemStack>)inventory.f_35976_, 0, previousUpgrade);
        }
        if (newUpgrade == null) {
            return new Object[]{false, "Cannot find a valid upgrade"};
        }
        if (previousUpgrade != null) {
            PocketAPI.storeItem(player, previousUpgrade.getUpgradeItem());
        }
        this.computer.setUpgrade(newUpgrade);
        return new Object[]{true};
    }

    @LuaFunction(mainThread=true)
    public final Object[] unequipBack() {
        Entity entity = this.computer.getEntity();
        if (!(entity instanceof Player)) {
            return new Object[]{false, "Cannot find player"};
        }
        Player player = (Player)entity;
        UpgradeData<IPocketUpgrade> previousUpgrade = this.computer.getUpgrade();
        if (previousUpgrade == null) {
            return new Object[]{false, "Nothing to unequip"};
        }
        this.computer.setUpgrade(null);
        PocketAPI.storeItem(player, previousUpgrade.getUpgradeItem());
        return new Object[]{true};
    }

    private static void storeItem(Player player, ItemStack stack) {
        ItemEntity drop;
        if (!stack.m_41619_() && !player.m_150109_().m_36054_(stack) && (drop = player.m_36176_(stack, false)) != null) {
            drop.m_32061_();
        }
    }

    @Nullable
    private static UpgradeData<IPocketUpgrade> findUpgrade(NonNullList<ItemStack> inv, int start, @Nullable UpgradeData<IPocketUpgrade> previous) {
        for (int i = 0; i < inv.size(); ++i) {
            UpgradeData<IPocketUpgrade> newUpgrade;
            ItemStack invStack = (ItemStack)inv.get((i + start) % inv.size());
            if (invStack.m_41619_() || (newUpgrade = PocketUpgrades.instance().get(invStack)) == null || Objects.equals(newUpgrade, previous)) continue;
            invStack = invStack.m_41777_();
            invStack.m_41774_(1);
            inv.set((i + start) % inv.size(), (Object)(invStack.m_41619_() ? ItemStack.f_41583_ : invStack));
            return newUpgrade;
        }
        return null;
    }
}

