/*
 * Decompiled with CFR 0.152.
 */
package de.johni0702.minecraft.bobby;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import de.johni0702.minecraft.bobby.ConfigBuilder;
import java.nio.file.Path;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.loading.FMLPaths;

public class BobbyConfig {
    public static ForgeConfigSpec ConfigSpec;
    private static ForgeConfigSpec.ConfigValue<Boolean> enabled;
    private static ForgeConfigSpec.ConfigValue<Boolean> noBlockEntities;
    private static ForgeConfigSpec.ConfigValue<Boolean> taintFakeChunks;
    private static ForgeConfigSpec.ConfigValue<Integer> unloadDelaySecs;
    private static ForgeConfigSpec.ConfigValue<Integer> deleteUnusedRegionsAfterDays;
    private static ForgeConfigSpec.ConfigValue<Integer> maxRenderDistance;
    private static ForgeConfigSpec.ConfigValue<Integer> viewDistanceOverwrite;

    public static void loadConfig(Path path) {
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
        configData.load();
        ConfigSpec.setConfig((CommentedConfig)configData);
    }

    public static boolean isNoBlockEntities() {
        return (Boolean)noBlockEntities.get();
    }

    public static boolean isEnabled() {
        return (Boolean)enabled.get();
    }

    public static boolean isTaintFakeChunks() {
        return (Boolean)taintFakeChunks.get();
    }

    public static int getUnloadDelaySecs() {
        return (Integer)unloadDelaySecs.get();
    }

    public static int getDeleteUnusedRegionsAfterDays() {
        return (Integer)deleteUnusedRegionsAfterDays.get();
    }

    public static int getMaxRenderDistance() {
        return (Integer)maxRenderDistance.get();
    }

    public static int getViewDistanceOverwrite() {
        return (Integer)viewDistanceOverwrite.get();
    }

    static {
        ConfigBuilder builder = new ConfigBuilder("Bobby Reforged Settings");
        builder.Block("General Settings", b -> {
            enabled = b.define("Enable Bobby", true);
            noBlockEntities = b.define("Do not load block entities in fake chunks", true);
            taintFakeChunks = b.define("Reduce the light levels in fake chunks", false);
            maxRenderDistance = b.define("Max Render Distance", (Object)32);
            viewDistanceOverwrite = b.define("Integrated Server View Distance override", (Object)0);
        });
        builder.Block("Unloading", b -> {
            unloadDelaySecs = b.define("Delay for unloading of chunks which are outside your view distance (seconds)", (Object)60);
            deleteUnusedRegionsAfterDays = b.define("Delay for deleting regions from the disk cache (days)", (Object)-1);
        });
        ConfigSpec = builder.Save();
        BobbyConfig.loadConfig(FMLPaths.CONFIGDIR.get().resolve("bobby.toml"));
    }
}

