/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.utils.serialization;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.extensions.IForgeFriendlyByteBuf;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import tv.soaryn.xycraft.core.utils.serialization.BinaryReader;
import tv.soaryn.xycraft.core.utils.serialization.BinarySerializer;
import tv.soaryn.xycraft.core.utils.serialization.BinaryWriter;
import tv.soaryn.xycraft.core.utils.serialization.MapReader;
import tv.soaryn.xycraft.core.utils.serialization.MapSerializer;
import tv.soaryn.xycraft.core.utils.serialization.MapWriter;

public interface Serializer<T>
extends MapSerializer<T>,
BinarySerializer<T> {
    public static final Serializer<Boolean> BOOLEAN = Serializer.ofUnchecked((val, emit) -> emit.makeBoolean((boolean)val), (prev, node) -> node.asBoolean(), (val, buf) -> buf.writeBoolean(val.booleanValue()), FriendlyByteBuf::readBoolean);
    public static final Serializer<Byte> BYTE = Serializer.ofUnchecked((val, emit) -> emit.makeByte((byte)val), (prev, node) -> node.asByte(), (val, buf) -> buf.writeByte((int)val.byteValue()), FriendlyByteBuf::readByte);
    public static final Serializer<byte[]> BYTE_ARRAY = Serializer.ofUnchecked((val, emit) -> emit.makeBlob(ByteBuffer.wrap(val)), (prev, node) -> node.asByteBlob().array(), (val, buf) -> buf.m_130087_(val), FriendlyByteBuf::m_130052_);
    public static final Serializer<Integer> INTEGER = Serializer.ofUnchecked((val, emit) -> emit.makeInt((int)val), (prev, node) -> node.asInt(), (val, buf) -> buf.writeInt(val.intValue()), FriendlyByteBuf::readInt);
    public static final Serializer<int[]> INTEGER_ARRAY = Serializer.ofUnchecked((val, emit) -> emit.makeBlob(IntBuffer.wrap(val)), (prev, node) -> node.asIntBlob().array(), (val, buf) -> buf.m_130089_(val), FriendlyByteBuf::m_130100_);
    public static final Serializer<Long> LONG = Serializer.ofUnchecked((val, emit) -> emit.makeLong((long)val), (prev, node) -> node.asLong(), (val, buf) -> buf.writeLong(val.longValue()), FriendlyByteBuf::readLong);
    public static final Serializer<long[]> LONG_ARRAY = Serializer.ofUnchecked((val, emit) -> emit.makeBlob(LongBuffer.wrap(val)), (prev, node) -> node.asLongBlob().array(), (val, buf) -> buf.m_130091_(val), FriendlyByteBuf::m_178381_);
    public static final Serializer<String> STRING = Serializer.ofUnchecked((val, emit) -> emit.makeString((String)val), (prev, node) -> node.asString(), (val, buf) -> buf.m_130070_(val), FriendlyByteBuf::m_130277_);
    public static final BinarySerializer<Vector3f> VECTOR3F = BinarySerializer.of((T val, FriendlyByteBuf buf) -> buf.writeFloat(val.x()).writeFloat(val.y()).writeFloat(val.z()), (FriendlyByteBuf buf) -> new Vector3f(buf.readFloat(), buf.readFloat(), buf.readFloat()));
    public static final BinarySerializer<Vec3i> VEC3I = BinarySerializer.of((T val, FriendlyByteBuf buf) -> buf.writeLong(new BlockPos(val).m_121878_()), (FriendlyByteBuf buf) -> BlockPos.m_122022_((long)buf.readLong()));
    public static final BinarySerializer<BlockPos> BLOCK_POS = BinarySerializer.of((T val, FriendlyByteBuf buf) -> buf.writeLong(val.m_121878_()), (FriendlyByteBuf buf) -> BlockPos.m_122022_((long)buf.readLong()));
    public static final BinarySerializer<BlockState> BLOCK_STATE = BinarySerializer.of((T val, FriendlyByteBuf buf) -> buf.m_130130_(Block.m_49956_((BlockState)val)), (FriendlyByteBuf buf) -> Block.m_49803_((int)buf.m_130242_()));
    public static final BinarySerializer<ItemStack> ITEM_STACK = BinarySerializer.of((T val, FriendlyByteBuf buf) -> buf.m_130055_(val), FriendlyByteBuf::m_130267_);
    public static final BinarySerializer<EquipmentSlot> EQUIPMENT_SLOT = BinarySerializer.of((T val, FriendlyByteBuf buf) -> buf.m_130068_((Enum)val), (FriendlyByteBuf buffer) -> (EquipmentSlot)buffer.m_130066_(EquipmentSlot.class));
    public static final BinarySerializer<FluidStack> FLUID_STACK = BinarySerializer.of((T val, FriendlyByteBuf buf) -> buf.writeFluidStack(val), IForgeFriendlyByteBuf::readFluidStack);

    @Override
    default public <V> Serializer<V> map(Function<V, T> encoder, Function<T, V> decoder) {
        return Serializer.of(MapSerializer.super.map(encoder, decoder), BinarySerializer.super.map(encoder, decoder));
    }

    @Override
    default public Serializer<T> nullable() {
        return Serializer.of(MapSerializer.super.nullable(), BinarySerializer.super.nullable());
    }

    public static <T> Serializer<T> placeholder() {
        return Serializer.of(MapSerializer.placeholder(), BinarySerializer.placeholder());
    }

    public static <T, S1, S2> Serializer<T> ofUnchecked(MapWriter.Unchecked<T, S1> mapSerializer, MapReader.Unchecked<T, S2> mapDeserializer, BinaryWriter<T> binaryWriter, BinaryReader<T> binaryReader) {
        return Serializer.of(MapSerializer.ofUnchecked(mapSerializer, mapDeserializer), BinarySerializer.of(binaryWriter, binaryReader));
    }

    public static <T> Serializer<T> of(MapWriter<T> mapWriter, MapReader<T> mapReader, BinaryWriter<T> binaryWriter, BinaryReader<T> binaryReader) {
        return Serializer.of(MapSerializer.of(mapWriter, mapReader), BinarySerializer.of(binaryWriter, binaryReader));
    }

    public static <T, V> Serializer<T> of(final MapSerializer<T> mapSerializer, final BinarySerializer<T> binarySerializer) {
        return new Serializer<T>(){

            @Override
            public <S> S serialize(T value, MapWriter.NodeEmitter<S> emit) {
                return mapSerializer.serialize(value, emit);
            }

            @Override
            public <S> T deserialize(@Nullable T value, MapReader.NodeToken<S> node) {
                return mapSerializer.deserialize(value, node);
            }

            @Override
            public void serialize(T value, FriendlyByteBuf buf) {
                binarySerializer.serialize(value, buf);
            }

            @Override
            public T deserialize(FriendlyByteBuf buf) {
                return binarySerializer.deserialize(buf);
            }

            @Override
            public Serializer<T> nullable() {
                return Serializer.of(mapSerializer.nullable(), binarySerializer.nullable());
            }
        };
    }

    public static <T> Serializer<T> ofBinarySerializer(BinarySerializer<T> serializer) {
        return Serializer.of(MapSerializer.ofBinarySerializer(serializer), serializer);
    }
}

