/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.loot;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.data.listener.IEarlyReloadListener;
import slimeknights.mantle.loot.LootTableInjection;
import slimeknights.mantle.util.JsonHelper;

public enum LootTableInjector implements IEarlyReloadListener
{
    INSTANCE;

    public static final String FOLDER = "mantle/loot_injectors";
    private ICondition.IContext context = ICondition.IContext.EMPTY;
    private Map<ResourceLocation, LootTableInjection> injections = Collections.emptyMap();

    public static void init() {
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, AddReloadListenerEvent.class, event -> {
            event.addListener((PreparableReloadListener)INSTANCE);
            LootTableInjector.INSTANCE.context = event.getConditionContext();
        });
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, LootTableLoadEvent.class, INSTANCE::lootTableLoad);
    }

    @Override
    public void onResourceManagerReload(ResourceManager manager) {
        long time = System.nanoTime();
        HashMap<ResourceLocation, LootTableInjection.Builder> builders = new HashMap<ResourceLocation, LootTableInjection.Builder>();
        int loaded = 0;
        for (Map.Entry entry2 : manager.m_214159_(FOLDER, loc -> loc.m_135815_().endsWith(".json")).entrySet()) {
            try {
                BufferedReader reader = ((Resource)entry2.getValue()).m_215508_();
                try {
                    JsonObject json = (JsonObject)GsonHelper.m_13776_((Gson)JsonHelper.DEFAULT_GSON, (Reader)reader, JsonObject.class);
                    if (json != null) {
                        if (json.keySet().isEmpty() || !CraftingHelper.processConditions((JsonObject)json, (String)"conditions", (ICondition.IContext)this.context)) continue;
                        LootTableInjection injection = LootTableInjection.LOADABLE.deserialize(json);
                        LootTableInjection.Builder builder = builders.computeIfAbsent(injection.name(), id -> new LootTableInjection.Builder());
                        for (LootTableInjection.LootPoolInjection pool : injection.pools()) {
                            builder.addToPool(pool);
                        }
                        ++loaded;
                        continue;
                    }
                    Mantle.logger.error("Couldn't parse loot table injection from {} as it's null or empty", entry2.getKey());
                }
                finally {
                    if (reader == null) continue;
                    ((Reader)reader).close();
                }
            }
            catch (JsonParseException | IOException | IllegalArgumentException ex) {
                Mantle.logger.error("Couldn't parse loot injection from {}", entry2.getKey(), (Object)ex);
            }
        }
        this.injections = builders.entrySet().stream().map(entry -> ((LootTableInjection.Builder)entry.getValue()).build((ResourceLocation)entry.getKey())).collect(Collectors.toUnmodifiableMap(LootTableInjection::name, Function.identity()));
        Mantle.logger.info("Loaded {} loot table injectors injecting into {} tables in {} ms", (Object)loaded, (Object)this.injections.size(), (Object)Float.valueOf((float)(System.nanoTime() - time) / 1000000.0f));
    }

    private void lootTableLoad(LootTableLoadEvent event) {
        LootTableInjection injection = this.injections.get(event.getName());
        if (injection != null) {
            Mantle.logger.debug("Injecting into {} pools in the table {}", (Object)injection.pools().size(), (Object)injection.name());
            LootTable table = event.getTable();
            for (LootTableInjection.LootPoolInjection pool : injection.pools()) {
                pool.inject(table);
            }
        }
    }
}

