/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.core.content.CustomColors;
import tv.soaryn.xycraft.core.content.capabilities.player.ColorCapability;
import tv.soaryn.xycraft.core.utils.ColorUtils;
import tv.soaryn.xycraft.machines.client.render.MachinesModelBakery;
import tv.soaryn.xycraft.machines.content.MachinesContent;

public class HoverPackArmorLayer<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    private static final ResourceLocation _armorLocation = new ResourceLocation("xycraft_machines", "textures/models/armor/test2.png");
    private static final ResourceLocation _emissiveLocation = new ResourceLocation("xycraft_machines", "textures/models/armor/test.png");

    public HoverPackArmorLayer(RenderLayerParent<T, M> renderer) {
        super(renderer);
    }

    public void render(@NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int light, @NotNull LivingEntity entity, float yaw, float pitch, float partialTick, float p_225628_8_, float p_225628_9_, float p_225628_10_) {
        if (entity.m_6844_(EquipmentSlot.CHEST).m_41720_() != MachinesContent.HoverPack.item()) {
            return;
        }
        EntityModel entityModel = this.m_117386_();
        if (!(entityModel instanceof HumanoidModel)) {
            return;
        }
        HumanoidModel model = (HumanoidModel)entityModel;
        int color = CustomColors.Red.getColor();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            color = ColorUtils.multiply((int)ColorCapability.colorOf((Player)player), (float)1.0f);
        }
        poseStack.m_85836_();
        model.f_102810_.m_104299_(poseStack);
        MachinesModelBakery.HoverPackEmissive.render(poseStack, bufferSource, RenderType.m_110452_((ResourceLocation)_emissiveLocation), light, color);
        MachinesModelBakery.HoverPack.render(poseStack, bufferSource, RenderType.m_110452_((ResourceLocation)_armorLocation), light, -1);
        poseStack.m_85849_();
    }

    public static <T extends LivingEntity> void registerOnAll(EntityRenderDispatcher renderManager) {
        for (EntityRenderer renderer : renderManager.getSkinMap().values()) {
            HoverPackArmorLayer.registerOn(renderer);
        }
        for (EntityRenderer renderer : renderManager.f_114362_.values()) {
            HoverPackArmorLayer.registerOn(renderer);
        }
    }

    public static void registerOn(EntityRenderer<?> entityRenderer) {
        if (!(entityRenderer instanceof LivingEntityRenderer)) {
            return;
        }
        LivingEntityRenderer livingRenderer = (LivingEntityRenderer)entityRenderer;
        if (!(livingRenderer.m_7200_() instanceof HumanoidModel)) {
            return;
        }
        HoverPackArmorLayer layer = new HoverPackArmorLayer(livingRenderer);
        livingRenderer.m_115326_(layer);
    }
}

