/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.compat.jei;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import tv.soaryn.xycraft.core.ui.NineSlicedResource;
import tv.soaryn.xycraft.core.ui.widget.ImageWidget;
import tv.soaryn.xycraft.core.utils.Utils;
import tv.soaryn.xycraft.core.utils.rules.FluidRuleGroup;
import tv.soaryn.xycraft.core.utils.rules.IRule;
import tv.soaryn.xycraft.machines.compat.jei.FluidBlockRenderer;
import tv.soaryn.xycraft.machines.compat.jei.JeiPlugin;
import tv.soaryn.xycraft.machines.content.MachinesContent;
import tv.soaryn.xycraft.machines.content.recipe.ExtractorRecipe;

public class ExtractorCategory
implements IRecipeCategory<ExtractorRecipe> {
    public static final ResourceLocation Id = new ResourceLocation("xycraft_machines", "extractor");
    public static final RecipeType<ExtractorRecipe> Type = new RecipeType(Id, ExtractorRecipe.class);
    private final IDrawable _icon;
    private final IDrawableStatic _background;
    private final FluidBlockRenderer fluidRenderer;

    public ExtractorCategory(IGuiHelper helper) {
        this._icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)MachinesContent.Extractor.block()));
        this._background = helper.createBlankDrawable(140, 101);
        this.fluidRenderer = new FluidBlockRenderer();
    }

    @NotNull
    public RecipeType<ExtractorRecipe> getRecipeType() {
        return Type;
    }

    @NotNull
    public Component getTitle() {
        return Component.m_237115_((String)"jei.recipe.extractor");
    }

    @NotNull
    public IDrawable getBackground() {
        return this._background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this._icon;
    }

    public void draw(@NotNull ExtractorRecipe recipe, @NotNull IRecipeSlotsView recipeSlotsView, @NotNull GuiGraphics graphics, double mouseX, double mouseY) {
        ImageWidget cube;
        ImageWidget image2 = new ImageWidget(null, new ResourceLocation("xycraft_machines", "textures/gui/icons/arrow_full.png"), 103.0f, 34.0f, 16.0f, 16.0f, -1429436382);
        ImageWidget image2Glow = new ImageWidget(null, new ResourceLocation("xycraft_machines", "textures/gui/icons/arrow_glow.png"), 103.0f, 34.0f, 16.0f, 16.0f, 0x77FFFFFF);
        NineSlicedResource slotUi = new NineSlicedResource(new ResourceLocation("xycraft_core", "textures/gui/sliced/slot2.png"));
        ImageWidget resultCube = cube = new ImageWidget(null, new ResourceLocation("xycraft_machines", "textures/gui/icons/generic_cube.png"), 0.0f, 0.0f, 16.0f, 16.0f, -1);
        ImageWidget invalid = new ImageWidget(null, new ResourceLocation("xycraft_machines", "textures/gui/icons/generic_cube.png"), 0.0f, 0.0f, 16.0f, 16.0f, -858993460);
        ImageWidget valid = new ImageWidget(null, new ResourceLocation("xycraft_machines", "textures/gui/icons/generic_cube.png"), 0.0f, 0.0f, 16.0f, 16.0f, -866792363);
        PoseStack stack = graphics.m_280168_();
        stack.m_85836_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.8f);
        slotUi.render(stack, 30.0f, 18.0f, 21.0f, 21.0f, 1.0f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        stack.m_85836_();
        stack.m_85841_(0.8f, 0.8f, 0.8f);
        stack.m_252781_(new Quaternionf().rotationZ(-1.5707964f));
        stack.m_252880_(-64.0f, 42.0f, 0.0f);
        image2.render(graphics, (int)mouseX, (int)mouseY, 0.0f);
        image2Glow.render(graphics, (int)mouseX, (int)mouseY, 0.0f);
        stack.m_85849_();
        stack.m_85836_();
        stack.m_252880_(92.0f, 50.0f, 10.0f);
        float scale = 1.0f;
        stack.m_85841_(scale, scale, scale);
        stack.m_85836_();
        stack.m_252880_(12.0f, 0.0f, 0.0f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.9f);
        stack.m_85837_(-0.5 * (double)Minecraft.m_91087_().f_91062_.m_92895_(Component.m_237115_((String)"jei.recipe.extractor.directions").getString()), -24.0, 0.0);
        graphics.m_280430_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)"jei.recipe.extractor.directions"), 0, 0, 0xF0F0F0);
        stack.m_85849_();
        RenderSystem.enableDepthTest();
        int x = 12;
        float y = (float)x * 0.5f;
        stack.m_85836_();
        cube.render(graphics, (int)mouseX, (int)mouseY, 0.0f);
        stack.m_85849_();
        resultCube = recipe.getValidDirections().contains(Direction.DOWN) ? valid : invalid;
        stack.m_85836_();
        stack.m_252880_(0.0f, (float)(-x), 1.0f);
        resultCube.render(graphics, (int)mouseX, (int)mouseY, 0.0f);
        stack.m_85849_();
        resultCube = recipe.getValidDirections().contains(Direction.UP) ? valid : invalid;
        stack.m_85836_();
        stack.m_252880_(0.0f, (float)x, -1.0f);
        resultCube.render(graphics, (int)mouseX, (int)mouseY, 0.0f);
        stack.m_85849_();
        resultCube = recipe.getValidDirections().contains(Direction.WEST) ? valid : invalid;
        stack.m_85836_();
        stack.m_252880_((float)(-x), -y, -1.0f);
        resultCube.render(graphics, (int)mouseX, (int)mouseY, 0.0f);
        stack.m_85849_();
        resultCube = recipe.getValidDirections().contains(Direction.NORTH) ? valid : invalid;
        stack.m_85836_();
        stack.m_252880_((float)x, -y, -1.0f);
        resultCube.render(graphics, (int)mouseX, (int)mouseY, 0.0f);
        stack.m_85849_();
        resultCube = recipe.getValidDirections().contains(Direction.EAST) ? valid : invalid;
        stack.m_85836_();
        stack.m_252880_((float)(-x), y, 1.0f);
        resultCube.render(graphics, (int)mouseX, (int)mouseY, 0.0f);
        stack.m_85849_();
        resultCube = recipe.getValidDirections().contains(Direction.SOUTH) ? valid : invalid;
        stack.m_85836_();
        stack.m_252880_((float)x, y, 1.0f);
        resultCube.render(graphics, (int)mouseX, (int)mouseY, 0.0f);
        stack.m_85849_();
        stack.m_85849_();
        stack.m_85836_();
        stack.m_252880_(4.0f, 4.0f, 0.0f);
        BigDecimal bigDecimal = BigDecimal.valueOf((double)recipe.getTicks() / 20.0);
        DecimalFormat df = new DecimalFormat("#.##");
        bigDecimal = bigDecimal.setScale(2, RoundingMode.HALF_UP);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        MutableComponent time = Component.m_237115_((String)"jei.recipe.general.time").m_130946_(": " + df.format((float)recipe.getTicks() / 20.0f) + " ").m_7220_((Component)Component.m_237115_((String)"jei.recipe.general.seconds"));
        graphics.m_280430_(Minecraft.m_91087_().f_91062_, (Component)time, 0, 0, 0xF0F0F0);
        stack.m_85849_();
        stack.m_85849_();
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull ExtractorRecipe recipe, @NotNull IFocusGroup focuses) {
        if (recipe.getCatalyst() != null) {
            IRule rule = recipe.getCatalyst();
            this.buildIngredient(32, 78, builder, rule);
        }
        this.buildIngredient(32, 64, builder, recipe.getTarget());
        int i = 0;
        int centerX = 32;
        int centerY = 64;
        float[] indices = new float[]{1.5707964f, 4.712389f, (float)Math.PI, 0.0f};
        for (IRule adj : recipe.getAdjacentRules()) {
            int x = 24;
            boolean y = false;
            float angle = indices[i++] + 0.7853982f;
            float c = Mth.m_14089_((float)angle);
            float s = Mth.m_14031_((float)angle) / 2.0f;
            float xRot = (float)x * c - (float)y * s;
            float yRot = (float)x * s + (float)y * c;
            this.buildIngredient((int)(xRot + (float)centerX), (int)(yRot + (float)centerY), builder, adj);
        }
        FluidType waterlogged = recipe.getWaterloggedFluid();
        builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 32, 50).addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)MachinesContent.Extractor.block()));
        if (waterlogged != null) {
            builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 32, 50).setCustomRenderer((IIngredientType)ForgeTypes.FLUID_STACK, (IIngredientRenderer)this.fluidRenderer).addIngredient((IIngredientType)ForgeTypes.FLUID_STACK, (Object)new FluidStack((Fluid)Fluids.f_76193_, 1000));
        }
        if (recipe.isFluidRecipe()) {
            FluidStack fluidStack = recipe.getResultFluidView();
            builder.addSlot(RecipeIngredientRole.OUTPUT, 32, 20).setFluidRenderer(1L, false, 16, 16).addFluidStack(fluidStack.getFluid(), (long)fluidStack.getAmount(), fluidStack.getTag());
        } else {
            builder.addSlot(RecipeIngredientRole.OUTPUT, 32, 20).addItemStack(recipe.getResultItemView());
        }
    }

    private void buildIngredient(int x, int y, @NotNull IRecipeLayoutBuilder builder, IRule rule) {
        Level level = Utils.getClientLevel();
        assert (level != null);
        if (!(rule instanceof FluidRuleGroup)) {
            builder.addSlot(RecipeIngredientRole.INPUT, x, y).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, JeiPlugin.RuleToItems.get(rule));
        } else {
            builder.addSlot(RecipeIngredientRole.INPUT, x, y).setCustomRenderer((IIngredientType)ForgeTypes.FLUID_STACK, (IIngredientRenderer)this.fluidRenderer).addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, JeiPlugin.RuleToFluids.get(rule));
        }
    }
}

