/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.config;

import java.nio.file.Path;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;
import tv.soaryn.xycraft.core.utils.IRegister;
import tv.soaryn.xycraft.machines.config.EnergyType;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class MachinesConfig
implements IRegister {
    public static final MachinesConfig Instance = new MachinesConfig();
    public static final ForgeConfigSpec CommonConfigs;
    public static ForgeConfigSpec.IntValue PlanterLimit;
    public static ForgeConfigSpec.IntValue HoverPylonRange;
    public static ForgeConfigSpec.IntValue CollectorRange;
    public static ForgeConfigSpec.IntValue LightFieldRange;
    public static ForgeConfigSpec.BooleanValue LightFieldPreventsSieges;
    public static ForgeConfigSpec.BooleanValue LightFieldPreventEndermenWarpIn;
    public static ForgeConfigSpec.BooleanValue WaterBlockFillsContainer;
    public static ForgeConfigSpec.BooleanValue FluidVoidEmptiesContainer;
    public static ForgeConfigSpec.IntValue VoidContainmentFrequency;
    public static ForgeConfigSpec.IntValue VoidContainmentItemAmount;
    public static ForgeConfigSpec.IntValue VoidContainmentFluidAmount;
    public static ForgeConfigSpec.IntValue VoidContainmentPowerAmount;
    public static ForgeConfigSpec.IntValue HydroPumpProcessFrequency;
    public static ForgeConfigSpec.IntValue HydroPumpFluidAmount;
    public static ForgeConfigSpec.IntValue HydroPumpFluidExternalAmount;
    public static ForgeConfigSpec.IntValue SelectorProcessFrequency;
    public static ForgeConfigSpec.IntValue SelectorItemAmount;
    public static ForgeConfigSpec.IntValue SelectorFluidAmount;
    public static ForgeConfigSpec.IntValue SelectorPowerAmount;
    public static ForgeConfigSpec.IntValue TankSizeLimit;
    public static ForgeConfigSpec.IntValue TankStoragePerBlock;
    public static ForgeConfigSpec.IntValue TankTickRate;
    public static ForgeConfigSpec.IntValue FabricatorCraftFrequency;
    public static ForgeConfigSpec.IntValue ExtractorRevalidateFrequency;
    public static ForgeConfigSpec.IntValue BalloonOnAStickRange;
    public static ForgeConfigSpec.IntValue DuracellCapacity;
    public static ForgeConfigSpec.IntValue DuracellExtractionRate;
    public static ForgeConfigSpec.IntValue DuracellReceiveRate;
    public static ForgeConfigSpec.EnumValue<EnergyType> EnergyParadigm;

    private static void setupConfig(ForgeConfigSpec.Builder builder) {
        builder.push("General");
        EnergyParadigm = builder.comment("Which energy system should be used with XyCraft related machines.").defineEnum("energy_paradigm", (Enum)EnergyType.Xynergy);
        builder.pop();
        builder.push("BasicMachines");
        WaterBlockFillsContainer = builder.comment("Allow the Water Block to fill a fluid container with water").define("water_block_fills_container", true);
        FluidVoidEmptiesContainer = builder.comment("Allow the Fluid Void to empty a fluid container").define("fluid_void_empties_container", true);
        PlanterLimit = builder.comment("How many planters in a line are allowed to accelerate a plant growth").defineInRange("planter_limit", 16, 1, 128);
        builder.push("LightField");
        LightFieldRange = builder.comment("How Large of a radius should spawns be prevented").worldRestart().defineInRange("light_field_range", 24, 4, 128);
        LightFieldPreventsSieges = builder.comment("Determines if a light field block can prevent a siege from occurring.").define("light_field_siege_prevention", true);
        LightFieldPreventEndermenWarpIn = builder.comment("Determines if a light field block can prevent endermen from warping to within the field range.").define("light_field_ender_warp_prevention", true);
        builder.pop();
        FabricatorCraftFrequency = builder.comment("How frequently does the Fabricator try to craft its recipe in ticks.").defineInRange("fabricator_craft_frequency", 10, 5, 200);
        ExtractorRevalidateFrequency = builder.comment("How frequently does the Extractor try to revalidate its recipe in ticks.").defineInRange("extractor_revalidate_frequency", 10, 5, 200);
        BalloonOnAStickRange = builder.comment("How far a player may fly before severing the connection of the Balloon on a stick. Note, this is not a sphere.").defineInRange("balloon_on_a_stick_radius", 9, 3, 32);
        HoverPylonRange = builder.comment("How large of a radius should the player be able to fly around a hover pylon").worldRestart().defineInRange("hover_pylon_range", 16, 8, 64);
        CollectorRange = builder.comment("How large of a radius should the collector be allowed to pick up items").worldRestart().defineInRange("collector_pickup_range", 3, 1, 64);
        builder.comment("How much can a void container pull at once. Note, this is only how much it can draw itself, anything pushed to it will be voided immediately still!");
        builder.push("HydroPump");
        HydroPumpProcessFrequency = builder.comment("How frequently a cycle happens in ticks").defineInRange("hydro_pump_process_frequency", 10, 5, 1200);
        HydroPumpFluidAmount = builder.comment("How much fluid can the hydro pump push in a single cycle in milli-buckets").defineInRange("hydro_pump_fluid_push_amount", 100, 0, Integer.MAX_VALUE);
        HydroPumpFluidExternalAmount = builder.comment("How much fluid can an external source pull in milli-buckets").defineInRange("hydro_pump_fluid_external_pull_amount", 1000000000, 0, Integer.MAX_VALUE);
        builder.pop();
        builder.push("VoidContainment");
        VoidContainmentFrequency = builder.comment("How frequently a cycle happens in ticks").defineInRange("void_containment_process_frequency", 10, 5, 1200);
        VoidContainmentItemAmount = builder.comment("How many items can the void containment pull in a single process").defineInRange("void_containment_item_pull_amount", 8, 0, 576);
        VoidContainmentFluidAmount = builder.comment("How much fluid can the void containment pull in a single process in milli-buckets").defineInRange("void_containment_fluid_pull_amount", 100, 0, 1000);
        VoidContainmentPowerAmount = builder.comment("How much forge energy can the void containment pull in a single process").defineInRange("void_containment_power_pull_amount", 100, 0, Integer.MAX_VALUE);
        builder.pop();
        builder.comment("How much can a Creative Selector create. note, this is only how much it can push, anything pulling can pull as much as it desires!");
        builder.push("Selector");
        SelectorProcessFrequency = builder.comment("How frequently a cycle happens in ticks").defineInRange("selector_process_frequency", 5, 5, 1200);
        SelectorItemAmount = builder.comment("How many items can the selector push per cycle").defineInRange("selector_item_amount", 64, 1, 576);
        SelectorFluidAmount = builder.comment("How much fluid can the selector push per cycle in milli-buckets").defineInRange("selector_fluid_amount", 1000000000, 1, 1000000000);
        SelectorPowerAmount = builder.comment("How much forge energy can the selector push per cycle").defineInRange("selector_energy_amount", 16000, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.pop();
        builder.push("MultiBlocks");
        builder.comment("Cuboid fluid storage.");
        builder.push("Tank");
        TankSizeLimit = builder.comment("Maximum dimensions of a tank. A single dimension is measured from wall to wall (inclusive).").worldRestart().defineInRange("tank_size_limit", 13, 3, 33);
        TankStoragePerBlock = builder.comment("How much fluid can be stored for each empty air block in the defined box. Measured in milli-buckets (mB)").worldRestart().defineInRange("tank_storage_per_block", 8000, 1, 64000);
        TankTickRate = builder.comment("How frequently a tank will tick.").defineInRange("tank_tick_rate", 10, 5, 20);
        builder.pop();
        builder.pop();
        builder.push("EnergyContainers");
        builder.push("Duracell");
        DuracellCapacity = builder.comment("Power capacity").defineInRange("duracell_capacity", 1000, 1, Integer.MAX_VALUE);
        DuracellExtractionRate = builder.comment("Extraction rate").defineInRange("duracell_extraction_rate", 20, 0, Integer.MAX_VALUE);
        DuracellReceiveRate = builder.comment("Charge rate").defineInRange("duracell_receive_rate", 20, 0, Integer.MAX_VALUE);
        builder.pop();
        builder.pop();
    }

    public void register(ModLoadingContext context) {
        FMLPaths.getOrCreateGameRelativePath((Path)FMLPaths.CONFIGDIR.get().resolve("xycraft"));
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)CommonConfigs, "xycraft/machines_common.toml");
    }

    static {
        ForgeConfigSpec.Builder configBuilder = new ForgeConfigSpec.Builder();
        MachinesConfig.setupConfig(configBuilder);
        CommonConfigs = configBuilder.build();
    }
}

