/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.blocks;

import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.ServerStatsCounter;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Abilities;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.util.FakePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.core.content.blocks.SidePartBlock;
import tv.soaryn.xycraft.core.content.blocks.entities.CoreBlockEntity;
import tv.soaryn.xycraft.core.content.blocks.entities.IDataSync;
import tv.soaryn.xycraft.core.content.blocks.entities.IPacketDataSync;
import tv.soaryn.xycraft.core.content.blocks.entities.ITickable;
import tv.soaryn.xycraft.core.content.items.XyBlockItem;
import tv.soaryn.xycraft.machines.config.MachinesConfig;
import tv.soaryn.xycraft.machines.content.MachinesContent;
import tv.soaryn.xycraft.machines.content.MachinesSounds;
import tv.soaryn.xycraft.machines.content.blocks.properties.MachineStateProperties;

public class BalloonStakeBlock
extends SidePartBlock
implements EntityBlock,
ITickable {
    public BalloonStakeBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_280658_(NoteBlockInstrument.BASS).m_60978_(2.0f).m_60918_(SoundType.f_56736_).m_155954_(2.0f).m_60955_());
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)MachineStateProperties.Connected, (Comparable)Boolean.valueOf(true)));
    }

    public static XyBlockItem itemSupplier(Block block) {
        return new XyBlockItem(block, new Item.Properties().m_41487_(1));
    }

    public VoxelShape getDownShapeForBaking() {
        return BalloonStakeBlock.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new Entity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@NotNull Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> entityType) {
        return ITickable.getTicker((Level)level, (BlockState)state, entityType);
    }

    protected void m_7926_(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{MachineStateProperties.Connected});
    }

    public void m_6807_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState oldState, boolean moving) {
        super.m_6807_(state, level, pos, oldState, moving);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof Entity) {
            Entity stake = (Entity)blockEntity;
            Entity.BalloonStakeData data = stake.getData();
            if (data._id == -1) {
                return;
            }
            Player player = data.getPlayer(level);
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                data._bound = true;
                data._targetPlayer = player2;
                blockEntity.m_6596_();
                Abilities playerAbilities = player2.m_150110_();
                playerAbilities.f_35936_ = true;
                player2.m_6885_();
                blockEntity.m_6596_();
                float r = Mth.m_14036_((float)(level.m_213780_().m_188501_() - 0.5f), (float)-0.01f, (float)0.1f);
                level.m_5594_(null, pos, (SoundEvent)MachinesSounds.BalloonInflate.get(), SoundSource.PLAYERS, 0.3f, 1.0f + r);
            }
        }
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockState state = super.m_5573_(ctx);
        if (state == null) {
            return null;
        }
        return (BlockState)state.m_61124_((Property)MachineStateProperties.Connected, (Comparable)Boolean.valueOf(!(ctx.m_43723_() instanceof FakePlayer)));
    }

    public void m_6402_(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity entity, @NotNull ItemStack stack) {
        super.m_6402_(level, pos, state, entity, stack);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (entity instanceof FakePlayer) {
            return;
        }
        if (blockEntity instanceof Entity) {
            Entity stake = (Entity)blockEntity;
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                ServerStatsCounter serverstatscounter = player.m_8951_();
                serverstatscounter.m_6085_((Player)player, Stats.f_12988_.m_12902_((Object)Stats.f_12992_), 1000000);
                Entity.BalloonStakeData data = stake.getData();
                data._id = player.m_19879_();
                blockEntity.m_6596_();
            }
        }
    }

    public void m_6810_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState newState, boolean p_60519_) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof Entity) {
            Player player;
            Entity stake = (Entity)blockEntity;
            Entity.BalloonStakeData data = stake.getData();
            if (data._bound && (player = data.getPlayer(level)) != null) {
                float r = Mth.m_14036_((float)(level.m_213780_().m_188501_() - 0.5f), (float)-0.01f, (float)0.1f);
                level.m_5594_(null, pos, (SoundEvent)MachinesSounds.BalloonPop.get(), SoundSource.PLAYERS, 0.5f, 1.0f + r);
            }
        }
        super.m_6810_(state, level, pos, newState, p_60519_);
    }

    public static class Entity
    extends CoreBlockEntity
    implements ITickable.Server {
        public Entity(BlockPos pos, BlockState state) {
            super(MachinesContent.Stake.entity(), pos, state);
            this.Data = new BalloonStakeData();
        }

        public BalloonStakeData getData() {
            return (BalloonStakeData)this.Data;
        }

        public static BlockEntityType<?> supplier(Block block) {
            return new BlockEntityType(Entity::new, Set.of(block), CoreBlockEntity.DefaultFixer);
        }

        public void m_7651_() {
            BalloonStakeData data = this.getData();
            Level level = this.m_58904_();
            if (level == null || level.m_5776_()) {
                return;
            }
            data._bound = false;
            Player player = data.getPlayer(level);
            if (player != null) {
                data._id = -1;
                Abilities playerAbilities = player.m_150110_();
                playerAbilities.f_35936_ = player.m_7500_() || player.m_5833_();
                playerAbilities.f_35935_ = (player.m_7500_() || player.m_5833_()) && playerAbilities.f_35935_;
                player.m_6885_();
                level.m_151543_(this.m_58899_());
            }
            super.m_7651_();
        }

        public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
            super.onDataPacket(net, pkt);
            Level level = this.m_58904_();
            if (level != null) {
                level.markAndNotifyBlock(this.m_58899_(), level.m_46745_(this.m_58899_()), this.m_58900_(), this.m_58900_(), 3, 512);
            }
        }

        public void onLoad() {
            super.onLoad();
        }

        public AABB getRenderBoundingBox() {
            return super.getRenderBoundingBox().m_82400_((double)((Integer)MachinesConfig.BalloonOnAStickRange.get()).intValue());
        }

        public void onChunkUnloaded() {
            super.onChunkUnloaded();
            BalloonStakeData data = this.getData();
            if (data._bound) {
                data._id = -1;
                data._bound = false;
                Level level = this.m_58904_();
                if (level != null) {
                    level.m_151543_(this.m_58899_());
                }
            }
        }

        public void tickServer(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state) {
            int freq = 5;
            BalloonStakeData data = this.getData();
            Player player = data.getPlayer(level);
            int seed = pos.hashCode();
            if (data._bound && player == null) {
                this.popBalloon(pos, level, data, pos);
            }
            if (data._bound && player != null && (level.m_46467_() + (long)seed) % (long)freq == 0L) {
                Abilities playerAbilities = player.m_150110_();
                boolean prevFly = playerAbilities.f_35936_;
                playerAbilities.f_35936_ = true;
                if (!player.m_6084_()) {
                    BlockPos blockPos = player.m_20183_();
                    playerAbilities.f_35936_ = player.m_7500_();
                    player.m_6885_();
                    this.popBalloon(pos, level, data, blockPos);
                    return;
                }
                if (prevFly != playerAbilities.f_35936_) {
                    player.m_6885_();
                }
                Vec3 playerPos = player.m_20182_();
                Integer range = (Integer)MachinesConfig.BalloonOnAStickRange.get();
                Vec3 vecPosOfBlock = Vec3.m_82512_((Vec3i)pos);
                Vec3 dif = playerPos.m_82546_(vecPosOfBlock);
                Vec3i difI = new Vec3i(Mth.m_14040_((int)((int)dif.m_7096_())), Mth.m_14040_((int)((int)dif.m_7098_())), Mth.m_14040_((int)((int)dif.m_7094_())));
                if (difI.m_123341_() > range || difI.m_123342_() > range || difI.m_123343_() > range) {
                    playerAbilities.f_35936_ = player.m_7500_();
                    playerAbilities.f_35935_ = player.m_7500_() && playerAbilities.f_35935_;
                    player.m_183634_();
                    player.m_6885_();
                    BlockPos blockPos = player.m_20183_();
                    this.popBalloon(pos, level, data, blockPos);
                }
            }
        }

        private void popBalloon(BlockPos pos, Level level, BalloonStakeData data, BlockPos blockPos) {
            BlockState currentState = this.m_58900_();
            if (!((Boolean)currentState.m_61143_((Property)MachineStateProperties.Connected)).booleanValue()) {
                return;
            }
            data._bound = false;
            data._id = -1;
            this.m_6596_();
            BlockState state = (BlockState)this.m_58900_().m_61124_((Property)MachineStateProperties.Connected, (Comparable)Boolean.valueOf(false));
            level.m_46597_(pos, state);
            level.markAndNotifyBlock(this.m_58899_(), level.m_46745_(this.m_58899_()), state, state, 3, 512);
            float r = Mth.m_14036_((float)(level.m_213780_().m_188501_() - 0.5f), (float)-0.01f, (float)0.1f);
            level.m_5594_(null, blockPos, (SoundEvent)MachinesSounds.BalloonPop.get(), SoundSource.PLAYERS, 0.8f, 1.0f + r);
        }

        public static class BalloonStakeData
        implements IDataSync,
        IPacketDataSync {
            private boolean _bound;
            private int _id;
            private Player _targetPlayer = null;

            public Player getPlayer(Level level) {
                net.minecraft.world.entity.Entity entity;
                if (level == null) {
                    return this._targetPlayer;
                }
                if (this._targetPlayer == null && (entity = level.m_6815_(this._id)) instanceof Player) {
                    Player player;
                    this._targetPlayer = player = (Player)entity;
                }
                return this._targetPlayer;
            }

            public void onLoad(CoreBlockEntity coreBlockEntity) {
                this.getPlayer(coreBlockEntity.m_58904_());
            }

            public void save(CoreBlockEntity coreBlockEntity, @NotNull CompoundTag tag) {
                tag.m_128379_("bound_to_player", this._bound);
                tag.m_128405_("id", this._id);
            }

            public void load(CoreBlockEntity coreBlockEntity, @NotNull CompoundTag tag) {
                this._bound = tag.m_128471_("bound_to_player");
                this._id = tag.m_128451_("id");
            }

            @NotNull
            public CompoundTag getClientPacketData(CoreBlockEntity coreBlockEntity) {
                CompoundTag tag = new CompoundTag();
                tag.m_128379_("bound_to_player", this._bound);
                tag.m_128405_("id", this._id);
                return tag;
            }

            public void handleClientPacketData(CoreBlockEntity coreBlockEntity, CompoundTag tag) {
                this._bound = tag.m_128471_("bound_to_player");
                this._id = tag.m_128451_("id");
            }
        }
    }
}

