/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.blocks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.core.XyCore;
import tv.soaryn.xycraft.core.content.CustomColors;
import tv.soaryn.xycraft.core.content.blocks.CoreStateProperties;
import tv.soaryn.xycraft.core.content.blocks.entities.CoreBlockEntity;
import tv.soaryn.xycraft.core.content.blocks.entities.IColorData;
import tv.soaryn.xycraft.core.content.blocks.entities.IDataSync;
import tv.soaryn.xycraft.core.content.blocks.entities.IPacketDataSync;
import tv.soaryn.xycraft.core.content.blocks.entities.ITickable;
import tv.soaryn.xycraft.core.network.IByteBlockEntityPacketReceiver;
import tv.soaryn.xycraft.core.network.Packet;
import tv.soaryn.xycraft.core.network.packets.CBByteBlockEntityPacket;
import tv.soaryn.xycraft.core.utils.ColorSource;
import tv.soaryn.xycraft.core.utils.FakePlayerUtils;
import tv.soaryn.xycraft.core.utils.FlagUtils;
import tv.soaryn.xycraft.core.utils.container.EmptyMenu;
import tv.soaryn.xycraft.core.utils.container.ItemContainer;
import tv.soaryn.xycraft.core.utils.container.ItemHandlerToItemContainerAdapter;
import tv.soaryn.xycraft.core.utils.container.SimpleItemContainer;
import tv.soaryn.xycraft.machines.config.MachinesConfig;
import tv.soaryn.xycraft.machines.content.MachinesContent;
import tv.soaryn.xycraft.machines.gui.FabricatorMenu;

public class FabricatorBlockEntity
extends CoreBlockEntity
implements ITickable.Server,
MenuProvider,
IByteBlockEntityPacketReceiver {
    public FabricatorBlockEntity(BlockPos pos, BlockState state) {
        super(MachinesContent.Fabricator.entity(), pos, state);
        this.Data = new FabricatorData();
    }

    public static BlockEntityType<?> supplier(Block block) {
        return new BlockEntityType(FabricatorBlockEntity::new, Set.of(block), CoreBlockEntity.DefaultFixer);
    }

    public FabricatorData getData() {
        return (FabricatorData)this.Data;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (this.m_58900_().m_61143_((Property)CoreStateProperties.StateDirection) != side && cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.getData().InventoryLazyHandle.cast();
        }
        return super.getCapability(cap, side);
    }

    public void tickServer(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state) {
        FabricatorData data = this.getData();
        if (!data._craftState && !level.m_276867_(pos)) {
            data.setCanCraft(true);
            XyCore.Network.broadcast(level, pos, (Packet.ClientBound)new CBByteBlockEntityPacket(this.m_58899_(), 1));
        }
        if (data.canCraft(level, pos) && ITickable.shouldTick((Level)level, (int)data._seed, (int)((Integer)MachinesConfig.FabricatorCraftFrequency.get()))) {
            int i;
            IItemHandler handler;
            Iterator iterator;
            int ghostSlot;
            ItemHandlerToItemContainerAdapter ghostAdapted = new ItemHandlerToItemContainerAdapter((IItemHandler)data.GhostContainer.asItemHandler());
            CraftingContainer craftingContainer = FabricatorBlockEntity.createCraftingContainer((ItemContainer)data.GhostContainer, 0);
            CraftingRecipe recipe = data._recipeCache;
            if (recipe == null) {
                return;
            }
            CraftingContainer finalCrafting = FabricatorBlockEntity.createCraftingContainer((ItemContainer)new SimpleItemContainer(9), 0);
            Direction dir = (Direction)state.m_61143_((Property)CoreStateProperties.StateDirection);
            ArrayList<CraftingIngredient> listOfIngredients = new ArrayList<CraftingIngredient>(9);
            ArrayList itemHandlers = (ArrayList)Util.m_137537_(() -> {
                ArrayList<IItemHandler> list = new ArrayList<IItemHandler>();
                list.add(data._itemHandler);
                for (Direction value : Direction.values()) {
                    LazyOptional cap;
                    BlockEntity entity;
                    if (value == dir || (entity = level.m_7702_(pos.m_121945_(value))) == null || !(cap = entity.getCapability(ForgeCapabilities.ITEM_HANDLER, value.m_122424_())).isPresent() || !cap.resolve().isPresent()) continue;
                    list.add((IItemHandler)cap.resolve().get());
                }
                return list;
            });
            int strictFlag = data.MenuData.m_6413_(0);
            for (ghostSlot = 0; ghostSlot < 9; ++ghostSlot) {
                this.resetCraftingSandbox(craftingContainer, ghostAdapted);
                if (craftingContainer.m_8020_(ghostSlot).m_41619_() || !FlagUtils.getAccess((int)strictFlag, (int)((byte)ghostSlot))) continue;
                iterator = itemHandlers.iterator();
                while (iterator.hasNext() && !this.findInput(level, recipe, craftingContainer, finalCrafting, listOfIngredients, handler = (IItemHandler)iterator.next(), ghostSlot)) {
                }
            }
            for (ghostSlot = 0; ghostSlot < 9; ++ghostSlot) {
                this.resetCraftingSandbox(craftingContainer, ghostAdapted);
                if (craftingContainer.m_8020_(ghostSlot).m_41619_() || FlagUtils.getAccess((int)strictFlag, (int)((byte)ghostSlot))) continue;
                iterator = itemHandlers.iterator();
                while (iterator.hasNext() && !this.findInput(level, recipe, craftingContainer, finalCrafting, listOfIngredients, handler = (IItemHandler)iterator.next(), ghostSlot)) {
                }
            }
            int finalIngredientCount = 0;
            int intendedIngredientCount = 0;
            for (i = 0; i < finalCrafting.m_6643_(); ++i) {
                if (finalCrafting.m_8020_(i).m_41619_()) continue;
                ++finalIngredientCount;
            }
            for (i = 0; i < ghostAdapted.size() - 1; ++i) {
                if (ghostAdapted.get(i).m_41619_()) continue;
                ++intendedIngredientCount;
            }
            if (intendedIngredientCount == finalIngredientCount && recipe.m_5818_((Container)finalCrafting, level) && this.craft(recipe, finalCrafting, listOfIngredients)) {
                byte mode = data.getMode();
                if (mode != 2) {
                    return;
                }
                data.setCanCraft(false);
                XyCore.Network.broadcast(level, this.m_58899_(), (Packet.ClientBound)new CBByteBlockEntityPacket(this.m_58899_(), 0));
            }
        }
    }

    public void receivePacket(CBByteBlockEntityPacket packet) {
        Level level;
        if (packet.value() != 4) {
            this.getData().setCanCraft(packet.value() != 0);
            this.m_6596_();
        }
        if ((level = this.m_58904_()) == null) {
            return;
        }
        level.markAndNotifyBlock(this.m_58899_(), level.m_46745_(this.m_58899_()), this.m_58900_(), this.m_58900_(), 3, 512);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
        Level level = this.m_58904_();
        if (level != null) {
            level.markAndNotifyBlock(this.m_58899_(), level.m_46745_(this.m_58899_()), this.m_58900_(), this.m_58900_(), 3, 512);
        }
    }

    private void resetCraftingSandbox(CraftingContainer sandbox, ItemHandlerToItemContainerAdapter ghostAdapted) {
        for (int craftingSlot = 0; craftingSlot < 9; ++craftingSlot) {
            sandbox.m_6836_(craftingSlot, ghostAdapted.get(craftingSlot));
        }
    }

    private boolean findInput(Level level, CraftingRecipe recipe, CraftingContainer sandbox, CraftingContainer finalCrafting, List<CraftingIngredient> currentIngredients, IItemHandler handler, int ghostSlot) {
        ItemStack specificItemStack = sandbox.m_8020_(ghostSlot).m_41777_();
        int strictFlag = this.getData().MenuData.m_6413_(0);
        boolean isSpecific = FlagUtils.getAccess((int)strictFlag, (int)((byte)ghostSlot));
        for (int inventorySlot = handler.getSlots() - 1; inventorySlot >= 0; --inventorySlot) {
            ItemStack remainder;
            int amountNeededFromSlot = 1;
            for (CraftingIngredient existing : currentIngredients) {
                if (existing.slot != inventorySlot || handler != existing.handler) continue;
                ++amountNeededFromSlot;
            }
            ItemStack inputStack = handler.extractItem(inventorySlot, amountNeededFromSlot, true).m_41777_();
            if (inputStack.m_41619_() || inputStack.m_41613_() < amountNeededFromSlot || inputStack.hasCraftingRemainingItem() && !(remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)inputStack.getCraftingRemainingItem(), (boolean)true)).m_41619_()) continue;
            inputStack.m_41764_(1);
            if (isSpecific && !specificItemStack.equals(inputStack, true)) continue;
            sandbox.m_6836_(ghostSlot, inputStack);
            if (!recipe.m_5818_((Container)sandbox, level) || recipe.m_5874_((Container)sandbox, level.m_9598_()).equals(inputStack, true) && !isSpecific) continue;
            currentIngredients.add(new CraftingIngredient(handler, inputStack, inventorySlot));
            finalCrafting.m_6836_(ghostSlot, inputStack);
            return true;
        }
        return false;
    }

    private boolean craft(CraftingRecipe recipe, CraftingContainer finalCrafting, ArrayList<CraftingIngredient> listOfIngredients) {
        int o;
        int n;
        FabricatorData data = this.getData();
        Level level = this.m_58904_();
        if (level == null) {
            return false;
        }
        ArrayList<IItemHandler> usedHandlers = new ArrayList<IItemHandler>();
        ArrayList<ItemStack> remainingItemList = new ArrayList<ItemStack>();
        for (CraftingIngredient ingredient : listOfIngredients) {
            if (!usedHandlers.contains(ingredient.handler)) {
                usedHandlers.add(ingredient.handler);
            }
            if (!ingredient.inputStack.hasCraftingRemainingItem()) continue;
            remainingItemList.add(ingredient.inputStack.getCraftingRemainingItem());
        }
        ItemStack output = recipe.m_5874_((Container)finalCrafting, level.m_9598_());
        SimpleItemContainer sandboxInventory = new SimpleItemContainer(9);
        for (int i = 0; i < sandboxInventory.size(); ++i) {
            sandboxInventory.set(i, data.Inventory.get(i).m_41777_());
        }
        ArrayList<ItemStack> copyOfRemainders = new ArrayList<ItemStack>((Collection<ItemStack>)recipe.m_7457_((Container)finalCrafting));
        copyOfRemainders.removeIf(ItemStack::m_41619_);
        List<ItemStack> extraRemainders = remainingItemList.stream().filter(copyOfRemainders::contains).toList();
        IItemHandlerModifiable sandboxHandle = sandboxInventory.asItemHandler();
        Integer[] internalItemsNeeded = (Integer[])listOfIngredients.stream().filter(craftingIngredient -> craftingIngredient.handler() == data._itemHandler).map(CraftingIngredient::slot).toArray(Integer[]::new);
        Object object = internalItemsNeeded;
        int n2 = ((Integer[])object).length;
        for (n = 0; n < n2; ++n) {
            o = object[n];
            sandboxHandle.extractItem(o, 1, false);
        }
        object = internalItemsNeeded;
        n2 = ((Integer[])object).length;
        for (n = 0; n < n2; ++n) {
            IItemHandler inventoryHandler = data._itemHandler;
            o = object[n];
            ItemStack testStack = inventoryHandler.extractItem(o, 1, true);
            if (!testStack.hasCraftingRemainingItem() || ItemHandlerHelper.insertItemStacked((IItemHandler)sandboxHandle, (ItemStack)testStack.getCraftingRemainingItem(), (boolean)false).m_41619_()) continue;
            return false;
        }
        for (ItemStack remainder : extraRemainders) {
            if (ItemHandlerHelper.insertItemStacked((IItemHandler)sandboxHandle, (ItemStack)remainder.m_41777_(), (boolean)false).m_41619_()) continue;
            return false;
        }
        if (!ItemHandlerHelper.insertItemStacked((IItemHandler)sandboxHandle, (ItemStack)output.m_41777_(), (boolean)false).m_41619_()) {
            return false;
        }
        PlayerEvent.ItemCraftedEvent eventStruct = new PlayerEvent.ItemCraftedEvent(FakePlayerUtils.getFakePlayer((ServerLevel)((ServerLevel)level)), output, (Container)finalCrafting);
        MinecraftForge.EVENT_BUS.post((Event)eventStruct);
        for (CraftingIngredient ingredient : listOfIngredients) {
            ItemStack extracted = ingredient.handler.extractItem(ingredient.slot, 1, false);
            if (!extracted.hasCraftingRemainingItem()) continue;
            ItemHandlerHelper.insertItemStacked((IItemHandler)ingredient.handler, (ItemStack)extracted.getCraftingRemainingItem(), (boolean)false);
        }
        ItemHandlerHelper.insertItemStacked((IItemHandler)data._itemHandler, (ItemStack)output, (boolean)false);
        for (ItemStack extraRemainder : extraRemainders) {
            ItemHandlerHelper.insertItemStacked((IItemHandler)data._itemHandler, (ItemStack)extraRemainder, (boolean)false);
        }
        return true;
    }

    public static CraftingContainer createCraftingContainer(ItemContainer inventory, int offset) {
        TransientCraftingContainer craftingContainer = new TransientCraftingContainer((AbstractContainerMenu)new EmptyMenu(), 3, 3);
        for (int i = 0; i < 9; ++i) {
            craftingContainer.m_6836_(i, inventory.get(i + offset));
        }
        return craftingContainer;
    }

    @NotNull
    public Component m_5446_() {
        return Component.m_237115_((String)"block.xycraft_machines.fabricator");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, @NotNull Inventory playerInventory, @NotNull Player playerEntity) {
        return new FabricatorMenu(windowId, playerInventory, (BlockEntity)this, (ItemContainer)this.getData().Inventory, (ItemContainer)new ItemHandlerToItemContainerAdapter((IItemHandler)this.getData().GhostContainer.asItemHandler()), (ContainerData)this.getData().MenuData);
    }

    public class FabricatorData
    implements IDataSync,
    IColorData,
    IPacketDataSync {
        public SimpleContainerData MenuData = new SimpleContainerData(3);
        private CraftingRecipe _recipeCache = null;
        private int _seed;
        private boolean _craftState;
        public ItemContainer.Serializable Inventory = new SimpleItemContainer(9, () -> ((FabricatorBlockEntity)FabricatorBlockEntity.this).m_6596_());
        public final ItemContainer.Serializable GhostContainer = new SimpleItemContainer(10){

            public void set(int slot, @NotNull ItemStack stack) {
                super.set(slot, stack);
                Level level = FabricatorBlockEntity.this.m_58904_();
                if (level != null && slot >= 9) {
                    RecipeManager recipeManager = level.m_7465_();
                    CraftingContainer craftingContainer = FabricatorBlockEntity.createCraftingContainer((ItemContainer)this, 0);
                    FabricatorData.this._recipeCache = recipeManager.m_44015_(RecipeType.f_44107_, (Container)craftingContainer, level).orElse(null);
                    FabricatorBlockEntity.this.m_6596_();
                }
            }
        };
        private final IItemHandler _itemHandler = this.Inventory.asItemHandler();
        public LazyOptional<IItemHandler> InventoryLazyHandle = LazyOptional.of(() -> this._itemHandler);

        public FabricatorData() {
            this.MenuData.m_8050_(2, CustomColors.Blue.getColor());
        }

        public void onLoad(CoreBlockEntity coreBlockEntity) {
            this._seed = FabricatorBlockEntity.this.m_58899_().hashCode();
            Level level = coreBlockEntity.m_58904_();
            if (level == null) {
                return;
            }
            RecipeManager recipeManager = level.m_7465_();
            CraftingContainer craftingContainer = FabricatorBlockEntity.createCraftingContainer((ItemContainer)this.GhostContainer, 0);
            this._recipeCache = recipeManager.m_44015_(RecipeType.f_44107_, (Container)craftingContainer, level).orElse(null);
        }

        public void save(CoreBlockEntity coreBlockEntity, @NotNull CompoundTag tag) {
            tag.m_128365_("inventory", (Tag)this.Inventory.serializeNBT());
            tag.m_128365_("ghost_inventory", (Tag)this.GhostContainer.serializeNBT());
            tag.m_128379_("can_craft", this._craftState);
            tag.m_128405_("strict_slots", this.MenuData.m_6413_(0));
            tag.m_128405_("menu_mode", this.MenuData.m_6413_(1));
            tag.m_128405_("color", this.MenuData.m_6413_(2));
        }

        public void load(CoreBlockEntity coreBlockEntity, @NotNull CompoundTag tag) {
            this.Inventory.deserializeNBT(tag.m_128469_("inventory"));
            this.GhostContainer.deserializeNBT(tag.m_128469_("ghost_inventory"));
            this._craftState = tag.m_128471_("can_craft");
            this.MenuData.m_8050_(0, tag.m_128451_("strict_slots"));
            this.MenuData.m_8050_(1, tag.m_128451_("menu_mode"));
            this.MenuData.m_8050_(2, tag.m_128451_("color"));
        }

        public void invalidate(CoreBlockEntity coreBlockEntity) {
            this.InventoryLazyHandle.invalidate();
        }

        @NotNull
        public CompoundTag getClientPacketData(CoreBlockEntity coreBlockEntity) {
            CompoundTag tag = new CompoundTag();
            this.save(coreBlockEntity, tag);
            return tag;
        }

        public void handleClientPacketData(CoreBlockEntity coreBlockEntity, CompoundTag tag) {
            this.GhostContainer.deserializeNBT(tag.m_128469_("ghost_inventory"));
            this._craftState = tag.m_128471_("can_craft");
            this.MenuData.m_8050_(0, tag.m_128451_("strict_slots"));
            this.MenuData.m_8050_(1, tag.m_128451_("menu_mode"));
            this.MenuData.m_8050_(2, tag.m_128451_("color"));
        }

        public ColorSource getColor() {
            return new ColorSource.Arbitrary(this.MenuData.m_6413_(2));
        }

        public void setColor(ColorSource color) {
            this.MenuData.m_8050_(2, color.getColor());
        }

        public byte getMode() {
            return (byte)this.MenuData.m_6413_(1);
        }

        public boolean canCraft(Level level, BlockPos pos) {
            byte mode = this.getMode();
            if (mode == 0) {
                return true;
            }
            boolean hasSignal = level.m_276867_(pos);
            return (mode == 2 && this._craftState || mode == 1) && hasSignal;
        }

        public void setCanCraft(boolean flag) {
            this._craftState = flag;
        }
    }

    public record CraftingIngredient(IItemHandler handler, ItemStack inputStack, int slot) {
    }
}

