/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.level.LevelEvent;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.core.content.blocks.IColored;
import tv.soaryn.xycraft.core.content.blocks.SidePartBlock;
import tv.soaryn.xycraft.machines.content.MachinesContent;
import tv.soaryn.xycraft.machines.content.capabilities.volumes.HoverVolumeCache;

public class HoverPylonBlock
extends SidePartBlock
implements IColored {
    public HoverPylonBlock() {
        super(MachinesContent.MachineProperties().m_60955_().m_246843_(new FeatureFlag[]{FeatureFlags.f_244112_}));
    }

    public VoxelShape getDownShapeForBaking() {
        double min = 4.25829;
        double max = 16.0 - min;
        return Shapes.m_83110_((VoxelShape)HoverPylonBlock.m_49796_((double)6.0, (double)3.0, (double)6.0, (double)10.0, (double)15.0, (double)10.0), (VoxelShape)HoverPylonBlock.m_49796_((double)min, (double)0.0, (double)min, (double)max, (double)5.0, (double)max));
    }

    public void m_6807_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState oldState, boolean moving) {
        super.m_6807_(state, level, pos, oldState, moving);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            HoverVolumeCache.of((Level)serverLevel).add((Level)serverLevel, pos);
        }
    }

    public void m_6810_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState oldState, boolean moving) {
        super.m_6810_(state, level, pos, oldState, moving);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            HoverVolumeCache.of((Level)serverLevel).remove((Level)serverLevel, pos);
        }
    }

    public static void init() {
        MinecraftForge.EVENT_BUS.addGenericListener(Level.class, HoverVolumeCache::register);
        MinecraftForge.EVENT_BUS.addListener(HoverPylonBlock::onLoad);
    }

    public static void onLoad(LevelEvent.Load event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)levelAccessor;
            HoverVolumeCache.of((Level)serverLevel).load((Level)serverLevel);
        }
    }

    public int getColorOfItem(ItemStack stack, int index) {
        return -14505370;
    }
}

