/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.blocks.selectors;

import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.core.content.blocks.CoreStateProperties;
import tv.soaryn.xycraft.core.content.blocks.entities.CoreBlockEntity;
import tv.soaryn.xycraft.core.content.blocks.entities.IDataSync;
import tv.soaryn.xycraft.core.content.blocks.entities.IPacketDataSync;
import tv.soaryn.xycraft.core.content.blocks.entities.ITickable;
import tv.soaryn.xycraft.core.content.capabilities.player.ModifierKeyCapability;
import tv.soaryn.xycraft.machines.config.MachinesConfig;
import tv.soaryn.xycraft.machines.content.MachinesContent;
import tv.soaryn.xycraft.machines.content.blocks.selectors.SelectorAbstractBlock;
import tv.soaryn.xycraft.machines.utils.handler.InfiniteFluidHandler;

public class FluidSelectorBlock
extends SelectorAbstractBlock {
    @Override
    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new Entity(pos, state);
    }

    @Override
    @NotNull
    public InteractionResult onCenterHit(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand interactionHand, @NotNull BlockHitResult hitResult) {
        BlockEntity be = level.m_7702_(pos);
        ItemStack stack = player.m_21120_(interactionHand).m_41777_();
        if (be instanceof Entity) {
            Entity selector = (Entity)be;
            Entity.SelectorData data = selector.getData();
            if (player.m_36341_() || ModifierKeyCapability.of((Player)player) || stack.m_41619_()) {
                if (data.FluidBuffer.setSelected(FluidStack.EMPTY)) {
                    selector.m_6596_();
                    level.m_7260_(pos, state, state, 3);
                    level.m_46597_(pos, state);
                    return InteractionResult.m_19078_((boolean)level.m_5776_());
                }
                return level.m_5776_() ? InteractionResult.CONSUME_PARTIAL : InteractionResult.CONSUME;
            }
            FluidStack fluidInStack = FluidUtil.getFluidContained((ItemStack)stack).orElse(FluidStack.EMPTY);
            if (!fluidInStack.isEmpty()) {
                if (data.FluidBuffer.setSelected(fluidInStack)) {
                    selector.m_6596_();
                    level.m_7260_(pos, state, state, 3);
                    level.m_46597_(pos, state);
                    return InteractionResult.m_19078_((boolean)level.m_5776_());
                }
                return level.m_5776_() ? InteractionResult.CONSUME_PARTIAL : InteractionResult.CONSUME;
            }
            FluidStack selectedFluid = data.FluidBuffer.getSelected();
            if (!selectedFluid.isEmpty() && !player.m_7500_() && FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)interactionHand, (IFluidHandler)data.FluidBuffer)) {
                return InteractionResult.m_19078_((boolean)level.m_5776_());
            }
        }
        return InteractionResult.PASS;
    }

    public static class Entity
    extends CoreBlockEntity
    implements ITickable.Server {
        public Entity(BlockPos pos, BlockState state) {
            super(MachinesContent.FluidSelector.entity(), pos, state);
            this.Data = new SelectorData();
        }

        public SelectorData getData() {
            return (SelectorData)this.Data;
        }

        public static BlockEntityType<?> supplier(Block block) {
            return new BlockEntityType(Entity::new, Set.of(block), CoreBlockEntity.DefaultFixer);
        }

        public void tickServer(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state) {
            SelectorData data = this.getData();
            if (ITickable.shouldTick((Level)level, (int)data._seed, (int)((Integer)MachinesConfig.SelectorProcessFrequency.get()))) {
                FluidStack stack = data.FluidBuffer.getSelected();
                if (stack.isEmpty()) {
                    return;
                }
                Direction direction = (Direction)state.m_61143_((Property)CoreStateProperties.StateDirection);
                BlockPos posOfOther = pos.m_121945_(direction);
                BlockEntity otherBlockEntity = level.m_7702_(posOfOther);
                if (otherBlockEntity == null) {
                    return;
                }
                otherBlockEntity.getCapability(ForgeCapabilities.FLUID_HANDLER, direction.m_122424_()).ifPresent(handler -> handler.fill(stack.copy(), IFluidHandler.FluidAction.EXECUTE));
            }
        }

        public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
            super.onDataPacket(net, pkt);
            Level level = this.m_58904_();
            if (level != null) {
                level.markAndNotifyBlock(this.m_58899_(), level.m_46745_(this.m_58899_()), this.m_58900_(), this.m_58900_(), 3, 512);
            }
        }

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
            if (this.m_58900_().m_61143_((Property)CoreStateProperties.StateDirection) == side && cap == ForgeCapabilities.FLUID_HANDLER) {
                return this.getData().FluidBuffer.Handle.cast();
            }
            return super.getCapability(cap, side);
        }

        public static class SelectorData
        implements IDataSync,
        IPacketDataSync {
            public final InfiniteFluidHandler FluidBuffer = new InfiniteFluidHandler();
            private int _seed;

            public void onLoad(CoreBlockEntity coreBlockEntity) {
                this._seed = coreBlockEntity.m_58899_().hashCode();
            }

            public void save(CoreBlockEntity coreBlockEntity, @NotNull CompoundTag tag) {
                tag.m_128365_("selected", (Tag)this.FluidBuffer.getSelected().writeToNBT(new CompoundTag()));
            }

            public void load(CoreBlockEntity coreBlockEntity, @NotNull CompoundTag tag) {
                this.FluidBuffer.setSelected(FluidStack.loadFluidStackFromNBT((CompoundTag)tag.m_128469_("selected")));
            }

            public void invalidate(CoreBlockEntity coreBlockEntity) {
                this.FluidBuffer.Handle.invalidate();
            }

            @NotNull
            public CompoundTag getClientPacketData(CoreBlockEntity coreBlockEntity) {
                CompoundTag tag = new CompoundTag();
                tag.m_128365_("selected", (Tag)this.FluidBuffer.getSelected().writeToNBT(new CompoundTag()));
                return tag;
            }

            public void handleClientPacketData(CoreBlockEntity coreBlockEntity, CompoundTag tag) {
                this.FluidBuffer.setSelected(FluidStack.loadFluidStackFromNBT((CompoundTag)tag.m_128469_("selected")));
            }
        }
    }
}

