/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.items.modular;

import com.google.common.collect.ImmutableMultimap;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;
import tv.soaryn.xycraft.machines.content.items.modular.IModule;
import tv.soaryn.xycraft.machines.content.items.modular.modules.AttributeModuleItem;
import tv.soaryn.xycraft.machines.content.items.modular.modules.weapon.HunterModuleItem;

public interface IModuleStorage {
    public static final String KEY_MODULES = "modules";

    public static IModuleStorage of(ItemStack stack) {
        return (IModuleStorage)stack.m_41720_();
    }

    default public void add(ItemStack stack, ItemStack moduleStack) {
        Item item = moduleStack.m_41720_();
        if (!(item instanceof IModule)) {
            return;
        }
        IModule module = (IModule)item;
        CompoundTag tag = stack.m_41784_();
        ListTag moduleList = tag.m_128437_(KEY_MODULES, 10);
        moduleList.add((Object)moduleStack.serializeNBT());
        tag.m_128365_(KEY_MODULES, (Tag)moduleList);
        module.onAddTo(stack);
    }

    default public ArrayList<ItemStack> remove(@NotNull ItemStack stack, @NotNull IModule module, @Range(from=1L, to=8L) int amount) {
        CompoundTag tag = stack.m_41784_();
        ListTag moduleList = tag.m_128437_(KEY_MODULES, 10);
        ArrayList<ItemStack> returned = new ArrayList<ItemStack>();
        for (int i = moduleList.size() - 1; i >= 0; --i) {
            ItemStack moduleStack = IModule.getModuleStackFrom(moduleList.get(i));
            if (IModule.getIModuleFrom(moduleStack) == module) {
                returned.add(moduleStack);
                module.onRemoveFrom(stack);
                moduleList.remove(i);
            }
            if (returned.size() >= amount) break;
        }
        tag.m_128365_(KEY_MODULES, (Tag)moduleList);
        return returned;
    }

    public static Stream<IModule> getInstalledModules(ItemStack stack) {
        return stack.m_41784_().m_128437_(KEY_MODULES, 10).stream().map(IModule::getIModuleFrom).filter(Objects::nonNull);
    }

    public static Stream<ItemStack> getInstalledModuleStacks(ItemStack stack) {
        IModuleStorage.isInstalled(HunterModuleItem.class, stack);
        return stack.m_41784_().m_128437_(KEY_MODULES, 10).stream().map(IModule::getModuleStackFrom).filter(stack1 -> stack1.m_41720_() instanceof IModule);
    }

    public static <T extends IModule> boolean isInstalled(Class<T> request, ItemStack stack) {
        Stream<IModule> installedModules = IModuleStorage.getInstalledModules(stack);
        return installedModules.anyMatch(module -> request.equals(module.getClass()));
    }

    @NotNull
    public static ImmutableMultimap<Attribute, AttributeModifier> buildAttributesFromModules(EquipmentSlot slot, ItemStack stack) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        IModuleStorage.getInstalledModuleStacks(stack).filter(moduleStack -> moduleStack.m_41720_() instanceof AttributeModuleItem).map(moduleStack -> {
            AttributeModuleItem attributeModule = (AttributeModuleItem)moduleStack.m_41720_();
            return attributeModule.getAttributeModifiersFromModule(slot, (ItemStack)moduleStack);
        }).mapMulti((map, consumer) -> map.entries().forEach(entry -> consumer.accept(new ImmutablePair((Object)((Attribute)entry.getKey()), (Object)((AttributeModifier)entry.getValue()))))).collect(Collectors.groupingBy(pair -> new ImmutablePair((Object)((Attribute)pair.getLeft()), (Object)((AttributeModifier)pair.getRight()).m_22209_()))).forEach((key, value) -> {
            double amount = 0.0;
            Optional templateModifier = value.stream().findAny();
            if (templateModifier.isEmpty()) {
                return;
            }
            AttributeModifier resolved = (AttributeModifier)((ImmutablePair)templateModifier.get()).getRight();
            for (ImmutablePair attributeModifierPairs : value) {
                amount += ((AttributeModifier)attributeModifierPairs.getRight()).m_22218_();
            }
            Attribute attribute = (Attribute)key.getLeft();
            UUID uuid = (UUID)key.getRight();
            builder.put((Object)attribute, (Object)new AttributeModifier(uuid, resolved.m_22214_(), amount, resolved.m_22217_()));
        });
        return builder.build();
    }
}

