/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.multiblock;

import com.mojang.datafixers.util.Either;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import tv.soaryn.xycraft.core.content.CoreTags;

public record CuboidMultiBlockDescriptor(BlockPos min, BlockPos max) {
    public Optional<String> checkForErrors(BlockGetter level, FormationRules rules) {
        BlockPos.MutableBlockPos tempPos = new BlockPos.MutableBlockPos();
        for (int x = this.min.m_123341_(); x <= this.max.m_123341_(); ++x) {
            boolean xFace = x == this.min.m_123341_() || x == this.max.m_123341_();
            for (int y = this.min.m_123342_(); y <= this.max.m_123342_(); ++y) {
                boolean yFace = y == this.min.m_123342_() || y == this.max.m_123342_();
                for (int z = this.min.m_123343_(); z <= this.max.m_123343_(); ++z) {
                    boolean zFace = z == this.min.m_123343_() || z == this.max.m_123343_();
                    tempPos.m_122178_(x, y, z);
                    if (xFace && yFace || xFace && zFace || yFace && zFace) {
                        if (rules.isValid(level, (BlockPos)tempPos, BlockUsage.EDGE)) continue;
                        return Optional.of("Invalid edge at " + tempPos);
                    }
                    if (xFace || yFace || zFace) {
                        if (rules.isValid(level, (BlockPos)tempPos, BlockUsage.WALL)) continue;
                        return Optional.of("Invalid wall at " + tempPos);
                    }
                    if (rules.isValid(level, (BlockPos)tempPos, BlockUsage.INNER)) continue;
                    return Optional.of("Invalid inner block at " + tempPos);
                }
            }
        }
        return Optional.empty();
    }

    public static Either<CuboidMultiBlockDescriptor, String> tryFormOutwards(BlockGetter level, BlockPos origin, FormationRules rules) {
        if (!rules.isValid(level, origin, BlockUsage.INNER)) {
            return Either.right((Object)("No valid inner block at " + origin));
        }
        int[] availableInnerExtents = new int[]{rules.getMaxSize(Direction.Axis.X) - 2, rules.getMaxSize(Direction.Axis.Y) - 2, rules.getMaxSize(Direction.Axis.Z) - 2};
        BlockPos.MutableBlockPos tempPos = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos min = new BlockPos.MutableBlockPos().m_122190_((Vec3i)origin);
        BlockPos.MutableBlockPos max = new BlockPos.MutableBlockPos().m_122190_((Vec3i)origin);
        for (Direction direction : Direction.values()) {
            int availableAxisInnerExtents = availableInnerExtents[direction.m_122434_().ordinal()];
            Either<Integer, String> result = CuboidMultiBlockDescriptor.tryFindWall(level, tempPos.m_122190_((Vec3i)origin), direction, rules, availableAxisInnerExtents);
            Optional error = result.right();
            if (error.isPresent()) {
                return Either.right((Object)((String)error.get()));
            }
            result.ifLeft(amount -> {
                if (direction.m_122421_() == Direction.AxisDirection.POSITIVE) {
                    max.m_122175_(direction, amount.intValue());
                } else {
                    min.m_122175_(direction, amount.intValue());
                }
                int n = direction.m_122434_().ordinal();
                availableInnerExtents[n] = availableInnerExtents[n] - amount;
            });
        }
        CuboidMultiBlockDescriptor descriptor = new CuboidMultiBlockDescriptor(min.m_7949_(), max.m_7949_());
        Optional<String> error = descriptor.checkForErrors(level, rules);
        return error.map(Either::right).orElseGet(() -> Either.left((Object)descriptor));
    }

    private static Either<Integer, String> tryFindWall(BlockGetter level, BlockPos.MutableBlockPos pos, Direction direction, FormationRules rules, int maxInnerExtents) {
        pos.m_122173_(direction);
        for (int offset = 1; offset <= maxInnerExtents; ++offset) {
            if (!rules.isValid(level, (BlockPos)pos, BlockUsage.INNER)) {
                if (rules.isValid(level, (BlockPos)pos, BlockUsage.WALL)) {
                    return Either.left((Object)offset);
                }
                return Either.right((Object)("No valid inner block or wall at " + pos + " (towards: " + direction + ")"));
            }
            pos.m_122173_(direction);
        }
        if (rules.isValid(level, (BlockPos)pos, BlockUsage.WALL)) {
            return Either.left((Object)(maxInnerExtents + 1));
        }
        return Either.right((Object)("No valid wall at " + pos + " (towards: " + direction + ")"));
    }

    public static enum BlockUsage {
        INNER,
        WALL,
        EDGE;

    }

    public static interface FormationRules {
        public int getMaxSize(Direction.Axis var1);

        public boolean isValid(BlockGetter var1, BlockPos var2, BlockUsage var3);

        public static boolean isBlockGenerallyAccepted(BlockGetter level, BlockPos pos, BlockUsage type) {
            BlockState state = level.m_8055_(pos);
            if (type == BlockUsage.WALL) {
                if (state.m_204336_(CoreTags.Blocks.MultiBlockInvalidFace)) {
                    return false;
                }
                if (state.m_204336_(CoreTags.Blocks.MultiBlockValidFace)) {
                    return true;
                }
            } else if (type == BlockUsage.EDGE) {
                if (state.m_204336_(CoreTags.Blocks.MultiBlockInvalidFrame)) {
                    return false;
                }
                if (state.m_204336_(CoreTags.Blocks.MultiBlockValidFrame)) {
                    return true;
                }
            } else if (type == BlockUsage.INNER) {
                if (state.m_204336_(CoreTags.Blocks.MultiBlockInvalidEmpty)) {
                    return false;
                }
                if (state.m_204336_(CoreTags.Blocks.MultiBlockValidEmpty)) {
                    return true;
                }
                return state.m_60795_();
            }
            return !state.m_155947_() && state.m_60838_(level, pos);
        }
    }
}

