/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.gui;

import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.core.ui.BaseMenu;
import tv.soaryn.xycraft.core.utils.container.FancySlot;
import tv.soaryn.xycraft.core.utils.container.ItemContainer;
import tv.soaryn.xycraft.machines.content.MachinesContent;
import tv.soaryn.xycraft.machines.content.MachinesMenuContent;
import tv.soaryn.xycraft.machines.content.blocks.EngineeringTableBlock;
import tv.soaryn.xycraft.machines.content.items.modular.IModule;
import tv.soaryn.xycraft.machines.content.items.modular.IModuleStorage;

public class EngineeringTableMenu
extends BaseMenu {
    public final EngineeringTableBlock.Entity BlockEntity;
    private final Level _level;
    public final ContainerData menuData;

    public EngineeringTableMenu(int id, Inventory inventory, FriendlyByteBuf data) {
        this(id, inventory, inventory.f_35978_.m_9236_().m_7702_(data.m_130135_()), (ItemContainer)new EngineeringTableBlock.Entity.EngineeringTableData.Container(), (ContainerData)new SimpleContainerData(1));
    }

    public EngineeringTableMenu(int id, Inventory inventory, BlockEntity entity, ItemContainer inventoryContainer, ContainerData dataContainer) {
        super(MachinesMenuContent.EngineeringTable, id, inventory, null, 200, 192);
        this.menuData = dataContainer;
        EngineeringTableMenu.m_38886_((ContainerData)this.menuData, (int)1);
        this.m_38884_(this.menuData);
        this.BlockEntity = (EngineeringTableBlock.Entity)entity;
        this._level = inventory.f_35978_.m_9236_();
        BaseMenu.Region playerRegion = this.createRegion();
        BaseMenu.Region inventoryRegion = this.createRegion();
        playerRegion.addShiftTargets(new BaseMenu.RegionHandle[]{inventoryRegion});
        inventoryRegion.addShiftTargets(new BaseMenu.RegionHandle[]{playerRegion.reversed()});
        playerRegion.addPlayerSlots(20, 100, inventory);
        inventoryRegion.addSlot(64, 42, inventoryContainer, 0).withStackSizeLimit(1);
        for (int i = 1; i < inventoryContainer.size(); ++i) {
            inventoryRegion.addSlot(i * 18, 24, inventoryContainer, i).withStackSizeLimit(1);
        }
        inventoryRegion.onChanged(fancySlot -> this.moduleChanges(inventoryContainer, (FancySlot)fancySlot, this._level.m_5776_()));
    }

    private void moduleChanges(ItemContainer inventoryContainer, FancySlot fancySlot, boolean clientSide) {
        ItemStack moduleStorageStack = inventoryContainer.get(0);
        if (fancySlot.getIndex() == 0) {
            if (clientSide) {
                return;
            }
            if (moduleStorageStack.m_41619_()) {
                for (int i = 1; i < inventoryContainer.size(); ++i) {
                    inventoryContainer.set(i, ItemStack.f_41583_);
                }
            } else {
                int i;
                Stream<ItemStack> moduleStream = IModuleStorage.getInstalledModuleStacks(moduleStorageStack);
                for (i = 1; i < inventoryContainer.size(); ++i) {
                    inventoryContainer.set(i, ItemStack.f_41583_);
                }
                i = 1;
                for (ItemStack moduleStack : moduleStream::iterator) {
                    inventoryContainer.set(i++, moduleStack);
                }
            }
        } else {
            Item item;
            Item i = moduleStorageStack.m_41720_();
            if (!(i instanceof IModuleStorage)) {
                return;
            }
            IModuleStorage moduleStorage = (IModuleStorage)i;
            List<ItemStack> installed = IModuleStorage.getInstalledModuleStacks(moduleStorageStack).toList();
            ItemStack slotItem = fancySlot.m_7993_();
            ItemStack cursorItem = this.m_142621_();
            if (cursorItem.m_41613_() <= 1 && (item = cursorItem.m_41720_()) instanceof IModule) {
                IModule moduleAttempted = (IModule)item;
                item = slotItem.m_41720_();
                if (item instanceof IModule) {
                    IModule moduleInstalled = (IModule)item;
                    ItemStack tempModuleStorage = moduleStorageStack.m_41777_();
                    moduleStorage.remove(tempModuleStorage, moduleInstalled, 1);
                    if (moduleAttempted.isValidFor(tempModuleStorage)) {
                        inventoryContainer.set(fancySlot.getIndex(), this.m_142621_());
                        this.m_142503_(slotItem);
                    }
                }
            }
            for (ItemStack installedModuleStack : installed) {
                Item item2 = installedModuleStack.m_41720_();
                if (!(item2 instanceof IModule)) continue;
                IModule installedModule = (IModule)item2;
                moduleStorage.remove(moduleStorageStack, installedModule, 1);
            }
            for (int i2 = 1; i2 < inventoryContainer.size(); ++i2) {
                ItemStack moduleStack = inventoryContainer.get(i2);
                if (moduleStack.m_41619_()) continue;
                moduleStorage.add(moduleStorageStack, moduleStack);
            }
        }
    }

    public boolean m_6875_(@NotNull Player player) {
        return EngineeringTableMenu.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this._level, (BlockPos)this.BlockEntity.m_58899_()), (Player)player, (Block)MachinesContent.EngineeringTable.block());
    }

    public void onMessage(int component, FriendlyByteBuf buf) {
    }
}

