/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.gui.elements;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class GuiNumberField {
    public int x;
    public int y;
    public int width;
    public int height;
    public int buttonWidth = 10;
    protected EditBox textField;
    protected Button minusButton;
    protected Button plusButton;
    List<Component> tooltip = new ArrayList<Component>();

    public GuiNumberField(Font font, List<Renderable> renderables, int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.textField = new EditBox(font, x + this.buttonWidth + 1, y + 1, width - 2 * this.buttonWidth - 2, height - 2, (Component)Component.m_237119_());
        this.minusButton = Button.m_253074_((Component)Component.m_237113_((String)"-"), button -> {
            float valueChanged = 1.0f;
            if (Screen.m_96637_()) {
                valueChanged = 5.0f;
            }
            if (Screen.m_96638_()) {
                valueChanged = 10.0f;
            }
            this.setNumber(this.getNumber() - (double)valueChanged);
        }).m_252987_(x, y - 1, this.buttonWidth, height + 2).m_253136_();
        this.plusButton = Button.m_253074_((Component)Component.m_237113_((String)"+"), button -> {
            float valueChanged = 1.0f;
            if (Screen.m_96637_()) {
                valueChanged = 5.0f;
            }
            if (Screen.m_96638_()) {
                valueChanged = 10.0f;
            }
            this.setNumber(this.getNumber() + (double)valueChanged);
        }).m_252987_(x + width - this.buttonWidth, y - 1, this.buttonWidth, height + 2).m_253136_();
        renderables.add((Renderable)this.minusButton);
        renderables.add((Renderable)this.plusButton);
    }

    public double getNumber() {
        if (this.textField.m_94155_().isEmpty()) {
            return 0.0;
        }
        try {
            return DecimalFormat.getInstance().parse(this.textField.m_94155_()).doubleValue();
        }
        catch (ParseException e) {
            return 0.0;
        }
    }

    public void setNumber(double number) {
        this.textField.m_94144_(DecimalFormat.getInstance().format(number));
    }

    public void setTooltip(Component tooltip) {
        this.setTooltip(Collections.singletonList(tooltip));
    }

    public void setTooltip(List<Component> tooltip) {
        this.tooltip = tooltip;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        boolean flag;
        boolean result = this.textField.m_6375_(mouseX, mouseY, mouseButton);
        boolean bl = flag = mouseX >= (double)(this.x + this.buttonWidth) && mouseX < (double)(this.x + this.width - this.buttonWidth) && mouseY >= (double)this.y && mouseY < (double)(this.y + this.height);
        if (flag && mouseButton == 1) {
            this.textField.m_94144_("");
            this.textField.m_93692_(true);
            result = true;
        }
        return result;
    }

    public void drawNumberField(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.textField.m_253211_(this.y + 1);
        this.minusButton.m_253211_(this.y - 1);
        this.plusButton.m_253211_(this.y - 1);
        this.textField.m_88315_(graphics, mouseX, mouseY, partialTicks);
        this.minusButton.m_88315_(graphics, mouseX, mouseY, partialTicks);
        this.plusButton.m_88315_(graphics, mouseX, mouseY, partialTicks);
    }

    public void drawTooltip(GuiGraphics graphics, Screen screen, int mouseX, int mouseY) {
        boolean insideTextField = mouseX >= this.x + this.buttonWidth && mouseX < this.x + this.width - this.buttonWidth && mouseY >= this.y && mouseY < this.y + this.height;
        boolean insideMinusButton = mouseX >= this.x && mouseX < this.x + this.buttonWidth && mouseY >= this.y && mouseY < this.y + this.height;
        boolean insidePlusButton = mouseX >= this.x + this.width - this.buttonWidth && mouseX < this.x + this.width && mouseY >= this.y && mouseY < this.y + this.height;
        ArrayList<Object> textLines = new ArrayList<Object>();
        if (insideTextField) {
            textLines.addAll(this.tooltip);
        }
        if (insideMinusButton) {
            textLines.add(Component.m_237113_((String)"Hold ").m_7220_((Component)Component.m_237113_((String)"shift ").m_130940_(ChatFormatting.AQUA)).m_130946_("for ").m_7220_((Component)Component.m_237113_((String)"10").m_130940_(ChatFormatting.RED)));
            textLines.add(Component.m_237113_((String)"Hold ").m_7220_((Component)Component.m_237113_((String)"ctrl ").m_130940_(ChatFormatting.AQUA)).m_130946_("for ").m_7220_((Component)Component.m_237113_((String)"5").m_130940_(ChatFormatting.RED)));
        }
        if (insidePlusButton) {
            textLines.add(Component.m_237113_((String)"Hold ").m_7220_((Component)Component.m_237113_((String)"shift ").m_130940_(ChatFormatting.DARK_GREEN)).m_130946_("for ").m_7220_((Component)Component.m_237113_((String)"10").m_130940_(ChatFormatting.RED)));
            textLines.add(Component.m_237113_((String)"Hold ").m_7220_((Component)Component.m_237113_((String)"ctrl ").m_130940_(ChatFormatting.DARK_GREEN)).m_130946_("for ").m_7220_((Component)Component.m_237113_((String)"5").m_130940_(ChatFormatting.RED)));
        }
        graphics.m_280666_(screen.getMinecraft().f_91062_, textLines, mouseX - 10, mouseY + 25);
    }

    public void update() {
        this.textField.m_94120_();
    }

    public boolean charTyped(char typedChar, int keyCode) {
        if (!this.textField.m_93696_()) {
            return false;
        }
        return this.textField.m_5534_(typedChar, keyCode);
    }
}

