/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.p3pp3rf1y.sophisticatedcore.util.CountAbbreviator;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.LimitedBarrelBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.LimitedBarrelBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockBase;
import net.p3pp3rf1y.sophisticatedstorage.block.VerticalFacing;
import net.p3pp3rf1y.sophisticatedstorage.client.render.BarrelRenderer;
import net.p3pp3rf1y.sophisticatedstorage.client.render.DisplayItemRenderer;
import org.joml.Vector3f;

public class LimitedBarrelRenderer
extends BarrelRenderer<LimitedBarrelBlockEntity> {
    private static final float MULTIPLE_ITEMS_FONT_SCALE = 0.010416667f;
    private static final float SINGLE_ITEM_FONT_SCALE = 0.020833334f;
    private static final Style COUNT_DISPLAY_STYLE = Style.f_131099_.m_131150_(Minecraft.f_91058_).m_131136_(Boolean.valueOf(true));
    private final DisplayItemRenderer displayItemRenderer = new DisplayItemRenderer(0.5, new Vec3(0.0, 0.0, -0.0625));
    private final DisplayItemRenderer flatDisplayItemRenderer = new DisplayItemRenderer(0.5, Vec3.f_82478_);

    @Override
    public void render(LimitedBarrelBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        BlockState blockState = blockEntity.m_58900_();
        if (blockEntity.isPacked() || !(blockState.m_60734_() instanceof StorageBlockBase) || !blockEntity.hasDynamicRenderer() && !blockEntity.shouldShowCounts() && !this.holdsItemThatShowsUpgrades() && !blockEntity.shouldShowUpgrades()) {
            return;
        }
        boolean flatTop = (Boolean)blockState.m_61143_((Property)BarrelBlock.FLAT_TOP);
        Direction horizontalFacing = (Direction)blockState.m_61143_((Property)LimitedBarrelBlock.HORIZONTAL_FACING);
        this.renderItemCounts(blockEntity, poseStack, bufferSource, packedLight, flatTop, horizontalFacing, (VerticalFacing)((Object)blockState.m_61143_(LimitedBarrelBlock.VERTICAL_FACING)));
        this.renderFrontFace(blockEntity, poseStack, bufferSource, packedLight, packedOverlay, blockState, flatTop, horizontalFacing);
        this.renderHiddenTier(blockEntity, poseStack, bufferSource, packedLight, packedOverlay);
        this.renderHiddenLock(blockEntity, poseStack, bufferSource, packedLight, packedOverlay);
    }

    private void renderFrontFace(LimitedBarrelBlockEntity blockEntity, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, BlockState blockState, boolean flatTop, Direction horizontalFacing) {
        if (blockEntity.hasDynamicRenderer() || this.holdsItemThatShowsUpgrades() || blockEntity.shouldShowUpgrades()) {
            poseStack.m_85836_();
            poseStack.m_85837_(0.5, 0.5, 0.5);
            poseStack.m_252781_(DisplayItemRenderer.getNorthBasedRotation(horizontalFacing));
            VerticalFacing verticalFacing = (VerticalFacing)((Object)blockState.m_61143_(LimitedBarrelBlock.VERTICAL_FACING));
            if (verticalFacing != VerticalFacing.NO) {
                poseStack.m_252781_(DisplayItemRenderer.getNorthBasedRotation(verticalFacing.getDirection()));
            }
            poseStack.m_85837_(-0.5, -0.5, -(0.5 - (double)(flatTop ? 0.0f : 0.0625f)));
            if (blockEntity.hasDynamicRenderer()) {
                this.renderDisplayItems(blockEntity, poseStack, bufferSource, packedLight, packedOverlay, flatTop);
            }
            boolean holdsItemThatShowsUpgrades = this.holdsItemThatShowsUpgrades();
            if (blockEntity.shouldShowUpgrades() || holdsItemThatShowsUpgrades) {
                this.renderUpgrades(blockEntity, poseStack, bufferSource, packedLight, packedOverlay, flatTop, holdsItemThatShowsUpgrades);
            }
            poseStack.m_85849_();
        }
    }

    private void renderUpgrades(LimitedBarrelBlockEntity blockEntity, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, boolean flatTop, boolean holdsItemThatShowsUpgrades) {
        if (flatTop) {
            this.flatDisplayItemRenderer.renderUpgradeItems(blockEntity, poseStack, bufferSource, packedLight, packedOverlay, holdsItemThatShowsUpgrades, this.shouldShowDisabledUpgradesDisplay(blockEntity));
        } else {
            this.displayItemRenderer.renderUpgradeItems(blockEntity, poseStack, bufferSource, packedLight, packedOverlay, this.holdsItemThatShowsUpgrades(), this.shouldShowDisabledUpgradesDisplay(blockEntity));
        }
    }

    private void renderDisplayItems(LimitedBarrelBlockEntity blockEntity, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, boolean flatTop) {
        if (flatTop) {
            this.flatDisplayItemRenderer.renderDisplayItems(blockEntity, poseStack, bufferSource, packedLight, packedOverlay, !blockEntity.hasFullyDynamicRenderer());
        } else {
            this.displayItemRenderer.renderDisplayItems(blockEntity, poseStack, bufferSource, packedLight, packedOverlay, !blockEntity.hasFullyDynamicRenderer());
        }
    }

    private void renderItemCounts(LimitedBarrelBlockEntity blockEntity, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, boolean flatTop, Direction horizontalFacing, VerticalFacing verticalFacing) {
        if (!blockEntity.shouldShowCounts()) {
            return;
        }
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.5, 0.5);
        poseStack.m_252781_(DisplayItemRenderer.getNorthBasedRotation(horizontalFacing.m_122424_()));
        if (verticalFacing != VerticalFacing.NO) {
            poseStack.m_252781_(DisplayItemRenderer.getNorthBasedRotation(verticalFacing.getDirection().m_122424_()));
        }
        poseStack.m_85837_(0.5, -0.5, 0.5);
        List<Integer> slotCounts = blockEntity.getSlotCounts();
        float countDisplayYOffset = -(slotCounts.size() == 1 ? 0.25f : 0.11f);
        for (int displayItemIndex = 0; displayItemIndex < slotCounts.size(); ++displayItemIndex) {
            int count = slotCounts.get(displayItemIndex);
            if (count <= 0) continue;
            poseStack.m_85836_();
            Vector3f frontOffset = DisplayItemRenderer.getDisplayItemIndexFrontOffset(displayItemIndex, slotCounts.size());
            double xTranslation = -frontOffset.x();
            float yTranslation = frontOffset.y() + countDisplayYOffset;
            double zTranslation = 0.001 - (flatTop ? 0.0 : 0.046875);
            poseStack.m_85837_(xTranslation, (double)yTranslation, zTranslation);
            float scale = slotCounts.size() == 1 ? 0.020833334f : 0.010416667f;
            poseStack.m_85841_(scale, -scale, scale);
            MutableComponent countString = Component.m_237113_((String)CountAbbreviator.abbreviate((int)count, (int)(slotCounts.size() == 1 ? 6 : 5))).m_130948_(COUNT_DISPLAY_STYLE);
            Font font = Minecraft.m_91087_().f_91062_;
            float countDisplayXOffset = -font.m_92865_().m_92384_((FormattedText)countString) / 2.0f;
            poseStack.m_252880_(countDisplayXOffset, 0.0f, 0.0f);
            font.m_272077_((Component)countString, 0.0f, 0.0f, blockEntity.getSlotColor(displayItemIndex), false, poseStack.m_85850_().m_252922_(), bufferSource, Font.DisplayMode.NORMAL, 0, packedLight);
            poseStack.m_85849_();
        }
        poseStack.m_85849_();
    }
}

