/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.BooleanSupplier;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.p3pp3rf1y.sophisticatedstorage.SophisticatedStorage;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockEntity;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class LockRenderer {
    public static final Material LOCK_TEXTURE = new Material(InventoryMenu.f_39692_, SophisticatedStorage.getRL("block/lock"));

    private LockRenderer() {
    }

    public static void renderLock(StorageBlockEntity blockEntity, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, float yOffset, BooleanSupplier holdsCorrectItem) {
        VertexConsumer vertexConsumer;
        boolean translucentRender;
        if (!blockEntity.isLocked() || !holdsCorrectItem.getAsBoolean() && !blockEntity.shouldShowLock()) {
            return;
        }
        poseStack.m_85836_();
        poseStack.m_85837_(0.46875, (double)yOffset, -0.001);
        poseStack.m_85841_(0.0625f, 0.0625f, 0.0625f);
        poseStack.m_85836_();
        boolean bl = translucentRender = !blockEntity.shouldShowLock() && holdsCorrectItem.getAsBoolean();
        if (translucentRender) {
            TextureAtlasSprite sprite = LOCK_TEXTURE.m_119204_();
            vertexConsumer = sprite.m_118381_(bufferSource.m_6299_(RenderType.m_110473_((ResourceLocation)sprite.m_247685_())));
        } else {
            vertexConsumer = LOCK_TEXTURE.m_119194_(bufferSource, RenderType::m_110458_);
        }
        PoseStack.Pose pose = poseStack.m_85850_();
        Vector3f normal = new Vector3f(0.0f, 1.0f, 0.0f);
        pose.m_252943_().transform(normal);
        LockRenderer.renderQuad(vertexConsumer, pose.m_252922_(), normal, packedOverlay, packedLight, translucentRender ? 0.5f : 1.0f);
        poseStack.m_85849_();
        poseStack.m_85849_();
    }

    private static void renderQuad(VertexConsumer consumer, Matrix4f pose, Vector3f normal, int packedOverlay, int packedLight, float alpha) {
        float minX = 0.0f;
        int minY = 0;
        int maxY = 1;
        boolean maxX = true;
        float minU = 0.0f;
        float minV = 0.0f;
        float maxU = 1.0f;
        float maxV = 1.0f;
        LockRenderer.addVertex(pose, normal, consumer, maxY, minX, packedOverlay, packedLight, maxU, minV, alpha);
        LockRenderer.addVertex(pose, normal, consumer, minY, minX, packedOverlay, packedLight, maxU, maxV, alpha);
        LockRenderer.addVertex(pose, normal, consumer, minY, (float)maxX, packedOverlay, packedLight, minU, maxV, alpha);
        LockRenderer.addVertex(pose, normal, consumer, maxY, (float)maxX, packedOverlay, packedLight, minU, minV, alpha);
    }

    private static void addVertex(Matrix4f pose, Vector3f normal, VertexConsumer pConsumer, int pY, float pX, int packedOverlay, int packedLight, float u, float v, float alpha) {
        Vector4f pos = new Vector4f(pX, (float)pY, 0.0f, 1.0f);
        pose.transform(pos);
        pConsumer.m_5954_(pos.x(), pos.y(), pos.z(), 1.0f, 1.0f, 1.0f, alpha, u, v, packedOverlay, packedLight, normal.x(), normal.y(), normal.z());
    }
}

