/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.cna.content.electricity.wire;

import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.antarcticgardens.cna.config.CNAConfig;
import org.antarcticgardens.cna.content.electricity.connector.ElectricalConnectorBlockEntity;
import org.antarcticgardens.cna.content.electricity.wire.WireType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ElectricWireItem
extends Item {
    private final WireType wireType;

    public ElectricWireItem(Item.Properties properties, WireType wireType) {
        super(properties);
        this.wireType = wireType;
    }

    public static ElectricWireItem newCopperWire(Item.Properties properties) {
        return new ElectricWireItem(properties, WireType.COPPER);
    }

    public static ElectricWireItem newIronWire(Item.Properties properties) {
        return new ElectricWireItem(properties, WireType.OVERCHARGED_IRON);
    }

    public static ElectricWireItem newGoldenWire(Item.Properties properties) {
        return new ElectricWireItem(properties, WireType.OVERCHARGED_GOLD);
    }

    public static ElectricWireItem newDiamondWire(Item.Properties properties) {
        return new ElectricWireItem(properties, WireType.OVERCHARGED_DIAMOND);
    }

    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, @NotNull Player player, InteractionHand usedHand) {
        ItemStack item = player.m_21120_(usedHand);
        BlockPos boundToPos = this.getBoundConnector(item);
        if (boundToPos != null && player.m_6144_()) {
            this.playUnboundSound((Entity)player);
            player.m_5661_((Component)Component.m_237115_((String)"item.create_new_age.wire.message.unbound"), true);
            item.m_41749_("boundTo");
            return InteractionResultHolder.m_19090_((Object)item);
        }
        return InteractionResultHolder.m_19098_((Object)item);
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (isSelected) {
            BlockPos boundToPos = this.getBoundConnector(stack);
            if (boundToPos == null) {
                return;
            }
            if (!(level.m_7702_(boundToPos) instanceof ElectricalConnectorBlockEntity)) {
                stack.m_41749_("boundTo");
            }
            int maxLength = (Integer)CNAConfig.getCommon().maxWireLength.get();
            if (entity.m_20275_((double)boundToPos.m_123341_(), (double)boundToPos.m_123342_(), (double)boundToPos.m_123343_()) > (double)(maxLength * maxLength * 3)) {
                stack.m_41749_("boundTo");
                this.playUnboundSound(entity);
                if (entity instanceof Player) {
                    Player pl = (Player)entity;
                    pl.m_5661_((Component)Component.m_237110_((String)"item.create_new_age.wire.message.too_far", (Object[])new Object[]{maxLength}), true);
                }
            }
        }
    }

    public InteractionResult m_6225_(UseOnContext context) {
        BlockEntity clickedEntity = context.m_43725_().m_7702_(context.m_8083_());
        BlockPos boundToPos = this.getBoundConnector(context.m_43722_());
        if (clickedEntity instanceof ElectricalConnectorBlockEntity) {
            ElectricalConnectorBlockEntity clickedConnector = (ElectricalConnectorBlockEntity)clickedEntity;
            if (boundToPos == null) {
                this.setBoundConnector(context.m_43722_(), clickedConnector);
                this.playBoundSound((Entity)context.m_43723_());
                return InteractionResult.SUCCESS;
            }
            BlockPos clickedPos = clickedConnector.m_58899_();
            int maxLength = (Integer)CNAConfig.getCommon().maxWireLength.get();
            if (boundToPos.equals((Object)clickedPos)) {
                context.m_43723_().m_5661_((Component)Component.m_237115_((String)"item.create_new_age.wire.message.self_connect"), true);
                context.m_43722_().m_41749_("boundTo");
                return InteractionResult.FAIL;
            }
            if (clickedPos.m_123331_((Vec3i)boundToPos) > (double)Mth.m_144944_((int)maxLength)) {
                context.m_43723_().m_5661_((Component)Component.m_237110_((String)"item.create_new_age.wire.message.too_far", (Object[])new Object[]{maxLength}), true);
                return InteractionResult.FAIL;
            }
            if (clickedConnector.isConnected(boundToPos)) {
                context.m_43723_().m_5661_((Component)Component.m_237115_((String)"item.create_new_age.wire.message.already_connected"), true);
                context.m_43722_().m_41749_("boundTo");
                return InteractionResult.FAIL;
            }
            BlockEntity boundToEntity = context.m_43725_().m_7702_(boundToPos);
            if (boundToEntity instanceof ElectricalConnectorBlockEntity) {
                ElectricalConnectorBlockEntity boundToConnector = (ElectricalConnectorBlockEntity)boundToEntity;
                context.m_43722_().m_41749_("boundTo");
                boundToConnector.connect(clickedConnector, this.wireType);
                if (!context.m_43723_().m_7500_()) {
                    context.m_43722_().m_41774_(1);
                }
                this.playBoundSound((Entity)context.m_43723_());
                context.m_43723_().m_5661_((Component)Component.m_237115_((String)"item.create_new_age.wire.message.connected"), true);
                return InteractionResult.CONSUME;
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    private void playBoundSound(Entity entity) {
        entity.m_5496_(SoundEvents.f_12087_, 1.0f, 1.0f);
    }

    private void playUnboundSound(Entity entity) {
        entity.m_5496_(SoundEvents.f_12033_, 1.0f, 1.0f);
    }

    public BlockPos getBoundConnector(ItemStack stack) {
        CompoundTag tag = stack.m_41737_("boundTo");
        if (tag == null) {
            return null;
        }
        return NbtUtils.m_129239_((CompoundTag)tag);
    }

    public WireType getWireType() {
        return this.wireType;
    }

    private void setBoundConnector(ItemStack stack, ElectricalConnectorBlockEntity connector) {
        stack.m_41700_("boundTo", (Tag)NbtUtils.m_129224_((BlockPos)connector.m_58899_()));
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)CreateLang.translate((String)"tooltip.create_new_age.transfers", (Object[])new Object[0]).style(ChatFormatting.GRAY).component());
        tooltip.add((Component)CreateLang.text((String)" ").translate("tooltip.create_new_age.energy_per_tick", new Object[]{String.format("%,d", this.wireType.getConductivity())}).style(ChatFormatting.AQUA).component());
    }
}

