/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.cna.content.heat.plate;

import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.utility.CreateLang;
import com.tterrag.registrate.util.entry.BlockEntityEntry;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.antarcticgardens.cna.CNABlockEntityTypes;
import org.antarcticgardens.cna.config.CNAConfig;
import org.antarcticgardens.cna.content.heat.pipe.HeatPipeBlock;
import org.antarcticgardens.cna.content.heat.plate.SolarHeatingPlateBlockEntity;
import org.jetbrains.annotations.Nullable;

public class SolarHeatingPlateBlock
extends Block
implements EntityBlock,
IWrenchable {
    private final BlockEntityEntry<?> entry;
    private final int strength;

    public SolarHeatingPlateBlock(BlockBehaviour.Properties properties, BlockEntityEntry<?> entry, int strength) {
        super(properties.m_60978_(4.0f));
        this.entry = entry;
        this.strength = strength;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return this.entry.create(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        int on = HeatPipeBlock.massPipe++;
        if (HeatPipeBlock.massPipe >= 20) {
            HeatPipeBlock.massPipe = 0;
        }
        return (level1, blockPos, blockState, blockEntity) -> {
            if ((level1.m_46467_() + (long)on) % 20L != 0L || !(blockEntity instanceof SolarHeatingPlateBlockEntity)) {
                return;
            }
            SolarHeatingPlateBlockEntity ent = (SolarHeatingPlateBlockEntity)blockEntity;
            ent.tick(blockPos, level1, blockState);
        };
    }

    public static SolarHeatingPlateBlock createAdvanced(BlockBehaviour.Properties properties) {
        return new SolarHeatingPlateBlock(properties, CNABlockEntityTypes.ADVANCED_SOLAR_HEATING_PLATE, 60);
    }

    public static SolarHeatingPlateBlock createBasic(BlockBehaviour.Properties properties) {
        return new SolarHeatingPlateBlock(properties, CNABlockEntityTypes.BASIC_SOLAR_HEATING_PLATE, 20);
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)CreateLang.translate((String)"tooltip.create_new_age.generates", (Object[])new Object[0]).style(ChatFormatting.GRAY).component());
        tooltip.add((Component)CreateLang.text((String)" ").translate("tooltip.create_new_age.temperature.ps", new Object[]{(double)this.strength * (Double)CNAConfig.getCommon().solarPanelHeatMultiplier.get()}).style(ChatFormatting.AQUA).component());
    }
}

