/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.util.packet;

import com.railwayteam.railways.content.switches.TrackSwitchBlock;
import com.railwayteam.railways.content.switches.TrainHUDSwitchExtension;
import com.railwayteam.railways.multiloader.S2CPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SwitchDataUpdatePacket
implements S2CPacket {
    final boolean clear;
    final TrackSwitchBlock.SwitchState state;
    final boolean automatic;
    final boolean isWrong;
    final boolean isLocked;

    public SwitchDataUpdatePacket(TrackSwitchBlock.SwitchState state, boolean automatic, boolean isWrong, boolean isLocked) {
        this.state = state;
        this.automatic = automatic;
        this.isWrong = isWrong;
        this.isLocked = isLocked;
        this.clear = false;
    }

    protected SwitchDataUpdatePacket() {
        this.state = null;
        this.automatic = false;
        this.isWrong = false;
        this.isLocked = false;
        this.clear = true;
    }

    public static SwitchDataUpdatePacket clear() {
        return new SwitchDataUpdatePacket();
    }

    public SwitchDataUpdatePacket(FriendlyByteBuf buf) {
        this.clear = buf.readBoolean();
        if (this.clear) {
            this.state = null;
            this.automatic = false;
            this.isWrong = false;
            this.isLocked = false;
        } else {
            this.state = TrackSwitchBlock.SwitchState.values()[buf.readInt()];
            this.automatic = buf.readBoolean();
            this.isWrong = buf.readBoolean();
            this.isLocked = buf.readBoolean();
        }
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.clear);
        if (!this.clear) {
            buffer.writeInt(this.state.ordinal());
            buffer.writeBoolean(this.automatic);
            buffer.writeBoolean(this.isWrong);
            buffer.writeBoolean(this.isLocked);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handle(Minecraft mc) {
        if (this.clear) {
            TrainHUDSwitchExtension.switchState = null;
        } else {
            TrainHUDSwitchExtension.switchState = this.state;
            TrainHUDSwitchExtension.isAutomaticSwitch = this.automatic;
            TrainHUDSwitchExtension.isWrong = this.isWrong;
            TrainHUDSwitchExtension.isLocked = this.isLocked;
        }
    }
}

