/*
 * Decompiled with CFR 0.152.
 */
package de.maxanier.guideapi;

import com.google.common.base.Supplier;
import de.maxanier.guideapi.GuideConfig;
import de.maxanier.guideapi.api.GuideAPI;
import de.maxanier.guideapi.api.impl.Book;
import de.maxanier.guideapi.item.ItemGuideBook;
import de.maxanier.guideapi.util.APISetter;
import de.maxanier.guideapi.util.AnnotationHandler;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegisterEvent;

@Mod.EventBusSubscriber(modid="guideapi_vp", bus=Mod.EventBusSubscriber.Bus.MOD)
public class RegistrarGuideAPI {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"guideapi_vp");

    @SubscribeEvent
    public static void registerItems(RegisterEvent event) {
        if (!event.getRegistryKey().equals((Object)ForgeRegistries.ITEMS.getRegistryKey())) {
            return;
        }
        AnnotationHandler.gatherBooks();
        GuideConfig.buildConfiguration();
        for (Book book : GuideAPI.getBooks().values()) {
            ResourceLocation id = new ResourceLocation("guideapi_vp", book.getRegistryName().toString().replace(":", "-"));
            event.register(ForgeRegistries.ITEMS.getRegistryKey(), id, () -> new ItemGuideBook(book));
            APISetter.setBookForStack(book, (Supplier<ItemStack>)((Supplier)() -> new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(id))));
        }
    }
}

