/*
 * Decompiled with CFR 0.152.
 */
package de.maxanier.guideapi.gui;

import de.maxanier.guideapi.api.IPage;
import de.maxanier.guideapi.api.impl.Book;
import de.maxanier.guideapi.api.impl.abstraction.CategoryAbstract;
import de.maxanier.guideapi.api.impl.abstraction.EntryAbstract;
import de.maxanier.guideapi.button.ButtonBack;
import de.maxanier.guideapi.button.ButtonNext;
import de.maxanier.guideapi.button.ButtonPrev;
import de.maxanier.guideapi.button.ButtonSearch;
import de.maxanier.guideapi.gui.BaseScreen;
import de.maxanier.guideapi.gui.CategoryScreen;
import de.maxanier.guideapi.gui.SearchScreen;
import de.maxanier.guideapi.network.PacketHandler;
import de.maxanier.guideapi.network.PacketSyncEntry;
import de.maxanier.guideapi.wrapper.PageWrapper;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class EntryScreen
extends BaseScreen {
    public ResourceLocation outlineTexture;
    public ResourceLocation pageTexture;
    public Book book;
    public CategoryAbstract category;
    public EntryAbstract entry;
    public List<PageWrapper> pageWrapperList = new ArrayList<PageWrapper>();
    public ButtonBack buttonBack;
    public ButtonNext buttonNext;
    public ButtonPrev buttonPrev;
    public ButtonSearch buttonSearch;
    public int pageNumber;

    public EntryScreen(Book book, CategoryAbstract category, EntryAbstract entry, Player player, ItemStack bookStack) {
        super(entry.name, player, bookStack);
        this.book = book;
        this.category = category;
        this.entry = entry;
        this.pageTexture = book.getPageTexture();
        this.outlineTexture = book.getOutlineTexture();
        this.pageNumber = 0;
    }

    public void m_7856_() {
        super.m_7856_();
        this.entry.onInit(this.book, this.category, null, this.player, this.bookStack);
        this.pageWrapperList.clear();
        this.guiLeft = (this.f_96543_ - this.xSize) / 2;
        this.guiTop = (this.f_96544_ - this.ySize) / 2;
        this.buttonBack = new ButtonBack(this.guiLeft + this.xSize / 6, this.guiTop, btn -> this.f_96541_.m_91152_((Screen)new CategoryScreen(this.book, this.category, this.player, this.bookStack, this.entry)), this);
        this.m_142416_((GuiEventListener)this.buttonBack);
        this.buttonNext = new ButtonNext(this.guiLeft + 4 * this.xSize / 6, this.guiTop + 5 * this.ySize / 6, btn -> {
            if (this.pageNumber + 1 < this.pageWrapperList.size()) {
                this.nextPage();
            }
        }, this);
        this.m_142416_((GuiEventListener)this.buttonNext);
        this.buttonPrev = new ButtonPrev(this.guiLeft + this.xSize / 5, this.guiTop + 5 * this.ySize / 6, btn -> {
            if (this.pageNumber > 0) {
                this.prevPage();
            }
        }, this);
        this.m_142416_((GuiEventListener)this.buttonPrev);
        this.buttonSearch = new ButtonSearch(this.guiLeft + this.xSize / 6 - 25, this.guiTop + 5, btn -> this.f_96541_.m_91152_((Screen)new SearchScreen(this.book, this.player, this.bookStack, this)), this);
        this.m_142416_((GuiEventListener)this.buttonSearch);
        for (IPage page : this.entry.pageList) {
            page.onInit(this.book, this.category, this.entry, this.player, this.bookStack, this);
            this.pageWrapperList.add(new PageWrapper(this, this.book, this.category, this.entry, page, this.guiLeft, this.guiTop, this.player, this.f_96547_, this.bookStack));
        }
    }

    @Override
    public boolean m_7933_(int keyCode, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (keyCode == 259 || keyCode == this.f_96541_.f_91066_.f_92095_.getKey().m_84873_()) {
            this.f_96541_.m_91152_((Screen)new CategoryScreen(this.book, this.category, this.player, this.bookStack, this.entry));
            return true;
        }
        if ((keyCode == 265 || keyCode == 262) && this.pageNumber + 1 < this.pageWrapperList.size()) {
            this.nextPage();
            return true;
        }
        if ((keyCode == 264 || keyCode == 263) && this.pageNumber > 0) {
            this.prevPage();
            return true;
        }
        return super.m_7933_(keyCode, p_keyPressed_2_, p_keyPressed_3_);
    }

    public boolean m_6375_(double mouseX, double mouseY, int typeofClick) {
        if (!super.m_6375_(mouseX, mouseY, typeofClick)) {
            for (PageWrapper wrapper : this.pageWrapperList) {
                if (!wrapper.isMouseOnWrapper(mouseX, mouseY) || !wrapper.canPlayerSee()) continue;
                if (typeofClick == 0) {
                    this.pageWrapperList.get((int)this.pageNumber).page.onLeftClicked(this.book, this.category, this.entry, mouseX, mouseY, this.player, this);
                    return true;
                }
                if (typeofClick != 1) continue;
                this.pageWrapperList.get((int)this.pageNumber).page.onRightClicked(this.book, this.category, this.entry, mouseX, mouseY, this.player, this);
                return true;
            }
            if (typeofClick == 1) {
                this.f_96541_.m_91152_((Screen)new CategoryScreen(this.book, this.category, this.player, this.bookStack, this.entry));
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean m_6050_(double p_mouseScrolled_1_, double p_mouseScrolled_3_, double movement) {
        if (movement < 0.0) {
            this.nextPage();
        } else if (movement > 0.0) {
            this.prevPage();
        }
        return movement != 0.0 || super.m_6050_(p_mouseScrolled_1_, p_mouseScrolled_3_, movement);
    }

    public void nextPage() {
        if (this.pageNumber != this.pageWrapperList.size() - 1 && !this.pageWrapperList.isEmpty()) {
            ++this.pageNumber;
        }
    }

    public void m_7379_() {
        super.m_7379_();
        for (IPage page : this.entry.pageList) {
            page.onClose();
        }
        ResourceLocation key = null;
        for (Map.Entry<ResourceLocation, EntryAbstract> mapEntry : this.category.entries.entrySet()) {
            if (!mapEntry.getValue().equals(this.entry)) continue;
            key = mapEntry.getKey();
        }
        if (key != null) {
            PacketHandler.INSTANCE.sendToServer((Object)new PacketSyncEntry(this.book.getCategoryList().indexOf(this.category), key, this.pageNumber));
        }
    }

    public void prevPage() {
        if (this.pageNumber != 0) {
            --this.pageNumber;
        }
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float renderPartialTicks) {
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        graphics.m_280218_(this.pageTexture, this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        graphics.m_280246_((float)this.book.getColor().getRed() / 255.0f, (float)this.book.getColor().getGreen() / 255.0f, (float)this.book.getColor().getBlue() / 255.0f, 1.0f);
        graphics.m_280218_(this.outlineTexture, this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        this.pageNumber = Mth.m_14045_((int)this.pageNumber, (int)0, (int)(this.pageWrapperList.size() - 1));
        if (this.pageNumber < this.pageWrapperList.size() && this.pageWrapperList.get(this.pageNumber).canPlayerSee()) {
            this.pageWrapperList.get(this.pageNumber).draw(graphics, Minecraft.m_91087_().f_91073_.m_9598_(), mouseX, mouseY, this);
            this.pageWrapperList.get(this.pageNumber).drawExtras(graphics, mouseX, mouseY, this);
        }
        this.drawCenteredStringWithoutShadow(graphics, this.f_96547_, String.format("%d/%d", this.pageNumber + 1, this.pageWrapperList.size()), this.guiLeft + this.xSize / 2, this.guiTop + 5 * this.ySize / 6, 0);
        graphics.m_280653_(this.f_96547_, this.entry.getName(), this.guiLeft + this.xSize / 2, this.guiTop - 10, Color.WHITE.getRGB());
        this.buttonPrev.f_93624_ = this.pageNumber != 0;
        this.buttonNext.f_93624_ = this.pageNumber != this.pageWrapperList.size() - 1 && !this.pageWrapperList.isEmpty();
        super.m_88315_(graphics, mouseX, mouseY, renderPartialTicks);
    }
}

