/*
 * Decompiled with CFR 0.152.
 */
package de.maxanier.guideapi.item;

import de.maxanier.guideapi.GuideMod;
import de.maxanier.guideapi.api.BookEvent;
import de.maxanier.guideapi.api.IGuideItem;
import de.maxanier.guideapi.api.IGuideLinked;
import de.maxanier.guideapi.api.impl.Book;
import de.maxanier.guideapi.api.impl.abstraction.CategoryAbstract;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemGuideBook
extends Item
implements IGuideItem {
    @Nonnull
    private final Book book;
    private String translation_key;

    public ItemGuideBook(Book book) {
        super(new Item.Properties().m_41487_(1));
        this.book = book;
        this.setTranslation_key("guideapi_vp.book." + book.getRegistryName().m_135827_() + "." + book.getRegistryName().m_135815_());
    }

    public void m_7373_(ItemStack stack, Level playerIn, List<Component> tooltip, TooltipFlag advanced) {
        if (this.book.getAuthor() != null) {
            tooltip.add(this.book.getAuthor());
            if (advanced == TooltipFlag.Default.f_256730_) {
                tooltip.add((Component)Component.m_237113_((String)this.book.getRegistryName().toString()));
            }
        }
    }

    @Override
    public Book getBook(ItemStack stack) {
        return this.book;
    }

    @Nullable
    public String getCreatorModId(ItemStack itemStack) {
        return this.book.getRegistryName().m_135827_();
    }

    @Nonnull
    public Component m_7626_(ItemStack stack) {
        return this.getBook(stack).getItemName() != null ? this.getBook(stack).getItemName() : super.m_7626_(stack);
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack heldStack = player.m_21120_(hand);
        if (!world.m_5776_()) {
            return InteractionResultHolder.m_19090_((Object)heldStack);
        }
        BookEvent.Open event = new BookEvent.Open(this.book, heldStack, player);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            player.m_5661_(event.getCanceledText(), true);
            return InteractionResultHolder.m_19100_((Object)heldStack);
        }
        GuideMod.PROXY.openGuidebook(player, world, this.book, heldStack);
        return InteractionResultHolder.m_19090_((Object)heldStack);
    }

    @Nonnull
    public InteractionResult m_6225_(UseOnContext context) {
        if (!context.m_43725_().f_46443_ || !context.m_7078_()) {
            return InteractionResult.PASS;
        }
        ItemStack stack = context.m_43722_();
        BlockState state = context.m_43725_().m_8055_(context.m_8083_());
        Block block = state.m_60734_();
        if (block instanceof IGuideLinked) {
            IGuideLinked guideLinked = (IGuideLinked)block;
            ResourceLocation entryKey = guideLinked.getLinkedEntry(context.m_43725_(), context.m_8083_(), context.m_43723_(), stack);
            if (entryKey == null) {
                return InteractionResult.FAIL;
            }
            for (CategoryAbstract category : this.book.getCategoryList()) {
                if (!category.entries.containsKey(entryKey)) continue;
                GuideMod.PROXY.openEntry(this.book, category, category.entries.get(entryKey), context.m_43723_(), stack);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    @Nonnull
    protected String m_41467_() {
        if (this.translation_key == null) {
            this.translation_key = Util.m_137492_((String)"item", (ResourceLocation)ForgeRegistries.ITEMS.getKey((Object)this));
        }
        return this.translation_key;
    }

    protected void setTranslation_key(String name) {
        this.translation_key = Util.m_137492_((String)"item", (ResourceLocation)new ResourceLocation("guideapi_vp", name));
    }
}

