/*
 * Decompiled with CFR 0.152.
 */
package de.maxanier.guideapi.network;

import de.maxanier.guideapi.api.IGuideItem;
import de.maxanier.guideapi.api.util.NBTBookTags;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import org.apache.commons.lang3.Validate;

public class PacketSyncHome {
    public int page;

    static void encode(PacketSyncHome msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.page);
    }

    static PacketSyncHome decode(FriendlyByteBuf buf) {
        PacketSyncHome msg = new PacketSyncHome();
        msg.page = buf.readInt();
        return msg;
    }

    public static void handle(PacketSyncHome msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context ctx = contextSupplier.get();
        ServerPlayer player = ctx.getSender();
        Validate.notNull((Object)player);
        ctx.enqueueWork(() -> {
            ItemStack book = player.m_21206_();
            if (book.m_41619_() || !(book.m_41720_() instanceof IGuideItem)) {
                book = player.m_21205_();
            }
            if (!book.m_41619_() && book.m_41720_() instanceof IGuideItem && msg.page != -1) {
                if (!book.m_41782_()) {
                    book.m_41751_(new CompoundTag());
                }
                book.m_41783_().m_128405_(NBTBookTags.CATEGORY_PAGE_TAG, msg.page);
                book.m_41783_().m_128473_(NBTBookTags.CATEGORY_TAG);
                book.m_41783_().m_128473_(NBTBookTags.ENTRY_TAG);
            }
        });
        ctx.setPacketHandled(true);
    }

    public PacketSyncHome() {
        this.page = -1;
    }

    public PacketSyncHome(int page) {
        this.page = page;
    }
}

