/*
 * Decompiled with CFR 0.152.
 */
package de.maxanier.guideapi.page;

import com.google.common.collect.Lists;
import de.maxanier.guideapi.api.IPage;
import de.maxanier.guideapi.api.impl.Book;
import de.maxanier.guideapi.api.impl.abstraction.CategoryAbstract;
import de.maxanier.guideapi.api.impl.abstraction.EntryAbstract;
import de.maxanier.guideapi.api.util.BookHelper;
import de.maxanier.guideapi.api.util.GuiHelper;
import de.maxanier.guideapi.gui.BaseScreen;
import de.maxanier.guideapi.gui.EntryScreen;
import de.maxanier.guideapi.gui.LinkedEntryScreen;
import java.net.URI;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PageHolderWithLinks
implements IPage {
    private static final Logger LOGGER = LogManager.getLogger();
    private final IPage page;
    private final BookHelper bookHelper;
    private final List<ResourceLocation> lateLinks = Lists.newArrayList();
    private final List<Link> links = Lists.newArrayList();
    private long lastLinkClick = 0L;

    public PageHolderWithLinks(BookHelper bookHelper, IPage page) {
        this.page = page;
        this.bookHelper = bookHelper;
    }

    public PageHolderWithLinks addLink(EntryAbstract entry) {
        this.links.add(new EntryLink(entry));
        return this;
    }

    public PageHolderWithLinks addLink(ResourceLocation entry) {
        this.lateLinks.add(entry);
        return this;
    }

    public PageHolderWithLinks addLink(URLLink link) {
        this.links.add(link);
        return this;
    }

    public PageHolderWithLinks addLink(String resourceLocation) {
        this.addLink(new ResourceLocation(resourceLocation));
        return this;
    }

    @Override
    public boolean canSee(Book book, CategoryAbstract category, EntryAbstract entry, Player player, ItemStack bookStack, EntryScreen guiEntry) {
        return this.page.canSee(book, category, entry, player, bookStack, guiEntry);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void draw(GuiGraphics graphics, RegistryAccess registryAccess, Book book, CategoryAbstract category, EntryAbstract entry, int guiLeft, int guiTop, int mouseX, int mouseY, BaseScreen guiBase, Font fontRendererObj) {
        this.page.draw(graphics, registryAccess, book, category, entry, guiLeft, guiTop, mouseX, mouseY, guiBase, fontRendererObj);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawExtras(GuiGraphics graphics, Book book, CategoryAbstract category, EntryAbstract entry, int guiLeft, int guiTop, int mouseX, int mouseY, BaseScreen guiBase, Font fontRendererObj) {
        int ll = guiLeft + guiBase.xSize - 5;
        int y = guiTop + 10;
        for (Link l : this.links) {
            Component t = l.getDisplayName();
            graphics.m_280614_(fontRendererObj, t, ll, y, 0xFFFFFF, true);
            if (l.width == 0) {
                l.width = fontRendererObj.m_92852_((FormattedText)t);
            }
            y += 20;
        }
        this.page.drawExtras(graphics, book, category, entry, guiLeft, guiTop, mouseX, mouseY, guiBase, fontRendererObj);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onInit(Book book, CategoryAbstract category, EntryAbstract entry, Player player, ItemStack bookStack, EntryScreen guiEntry) {
        while (this.lateLinks.size() > 0) {
            ResourceLocation s = this.lateLinks.remove(0);
            EntryAbstract e = this.bookHelper.getLinkedEntry(s);
            if (e == null) {
                LOGGER.warn("Failed to find linked entry {}", (Object)s);
                continue;
            }
            this.addLink(e);
        }
        this.page.onInit(book, category, entry, player, bookStack, guiEntry);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onLeftClicked(Book book, CategoryAbstract category, EntryAbstract entry, double mouseX, double mouseY, Player player, EntryScreen guiEntry) {
        long lastClock;
        if (mouseX > (double)(guiEntry.guiLeft + guiEntry.xSize) && (lastClock = System.currentTimeMillis() / 4L) != this.lastLinkClick) {
            this.lastLinkClick = lastClock;
            for (int i = 0; i < this.links.size(); ++i) {
                if (!GuiHelper.isMouseBetween(mouseX, mouseY, guiEntry.guiLeft + guiEntry.xSize, guiEntry.guiTop + 10 + 20 * i, this.links.get((int)i).width, 20)) continue;
                this.links.get(i).onClicked(book, category, entry, player, guiEntry.bookStack, guiEntry.pageNumber);
                return;
            }
        }
        this.page.onLeftClicked(book, category, entry, mouseX, mouseY, player, guiEntry);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onRightClicked(Book book, CategoryAbstract category, EntryAbstract entry, double mouseX, double mouseY, Player player, EntryScreen guiEntry) {
        this.page.onRightClicked(book, category, entry, mouseX, mouseY, player, guiEntry);
    }

    private static class EntryLink
    extends Link {
        private final EntryAbstract linkedEntry;

        private EntryLink(EntryAbstract entry) {
            this.linkedEntry = entry;
        }

        @Override
        public Component getDisplayName() {
            return this.linkedEntry.getName();
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void onClicked(Book book, CategoryAbstract category, EntryAbstract entry, Player player, ItemStack bookStack, int page) {
            this.openLinkedEntry(book, category, this.linkedEntry, player, bookStack, entry, page);
        }

        @OnlyIn(value=Dist.CLIENT)
        private void openLinkedEntry(Book book, CategoryAbstract category, EntryAbstract entry, Player player, ItemStack bookStack, EntryAbstract from, int fromPage) {
            LinkedEntryScreen screen = new LinkedEntryScreen(book, category, entry, player, bookStack, from, fromPage);
            Minecraft.m_91087_().m_91152_((Screen)screen);
        }
    }

    private static abstract class Link {
        public int width;

        private Link() {
        }

        public abstract Component getDisplayName();

        @OnlyIn(value=Dist.CLIENT)
        public abstract void onClicked(Book var1, CategoryAbstract var2, EntryAbstract var3, Player var4, ItemStack var5, int var6);
    }

    public static class URLLink
    extends Link {
        private final Component name;
        private final URI link;

        public URLLink(String name, URI link) {
            this.name = Component.m_237113_((String)name);
            this.link = link;
        }

        public URLLink(Component name, URI link) {
            this.name = name;
            this.link = link;
        }

        @Override
        public Component getDisplayName() {
            return this.name;
        }

        @Override
        public void onClicked(Book book, CategoryAbstract category, EntryAbstract entry, Player player, ItemStack bookStack, int page) {
            Util.m_137581_().m_137648_(this.link);
        }
    }
}

