/*
 * Decompiled with CFR 0.152.
 */
package de.maxanier.guideapi.page;

import de.maxanier.guideapi.api.impl.Book;
import de.maxanier.guideapi.api.impl.abstraction.CategoryAbstract;
import de.maxanier.guideapi.api.impl.abstraction.EntryAbstract;
import de.maxanier.guideapi.api.util.GuiHelper;
import de.maxanier.guideapi.api.util.IngredientCycler;
import de.maxanier.guideapi.gui.BaseScreen;
import de.maxanier.guideapi.page.PageText;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PageItemStack
extends PageText {
    private final IngredientCycler ingredientCycler = new IngredientCycler();
    public Ingredient ingredient;

    public PageItemStack(FormattedText draw, Ingredient ingredient) {
        super(draw, 60);
        this.ingredient = ingredient;
    }

    public PageItemStack(FormattedText draw, ItemStack ingredient) {
        this(draw, Ingredient.m_43927_((ItemStack[])new ItemStack[]{ingredient}));
    }

    public PageItemStack(FormattedText draw, Item item) {
        this(draw, new ItemStack((ItemLike)item));
    }

    public PageItemStack(FormattedText draw, Block block) {
        this(draw, new ItemStack((ItemLike)block));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawExtras(GuiGraphics graphics, Book book, CategoryAbstract category, EntryAbstract entry, int guiLeft, int guiTop, int mouseX, int mouseY, BaseScreen guiBase, Font fontRendererObj) {
        this.ingredientCycler.tick(guiBase.getMinecraft());
        this.ingredientCycler.getCycledIngredientStack(this.ingredient, 0).ifPresent(s -> GuiHelper.drawScaledItemStack(graphics, s, guiLeft + 101, guiTop + 20, 3.0f));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PageItemStack)) {
            return false;
        }
        PageItemStack that = (PageItemStack)o;
        if (!super.equals(o)) {
            return false;
        }
        return Objects.equals(this.ingredient, that.ingredient);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.ingredient != null ? this.ingredient.hashCode() : 0);
        return result;
    }
}

