/*
 * Decompiled with CFR 0.152.
 */
package de.maxanier.guideapi.util;

import com.google.common.collect.Multimap;
import de.maxanier.guideapi.GuideConfig;
import de.maxanier.guideapi.api.GuideAPI;
import de.maxanier.guideapi.api.IGuideItem;
import de.maxanier.guideapi.api.IGuideLinked;
import de.maxanier.guideapi.api.IInfoRenderer;
import de.maxanier.guideapi.api.impl.Book;
import de.maxanier.guideapi.api.impl.abstraction.CategoryAbstract;
import java.util.Collection;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.ItemHandlerHelper;

@Mod.EventBusSubscriber(modid="guideapi_vp")
public class EventHandler {
    @SubscribeEvent
    public static void onPlayerJoinWorld(EntityJoinLevelEvent event) {
        Entity entity;
        if (!event.getEntity().m_20193_().f_46443_ && (entity = event.getEntity()) instanceof Player) {
            Player player = (Player)entity;
            CompoundTag tag = EventHandler.getModTag(player, "guideapi_vp");
            if (((Boolean)GuideConfig.COMMON.canSpawnWithBook.get()).booleanValue()) {
                for (Book book : GuideAPI.getBooks().values()) {
                    ForgeConfigSpec.BooleanValue bookSpawnConfig = GuideConfig.COMMON.SPAWN_BOOKS.get(book);
                    if (bookSpawnConfig != null && !((Boolean)bookSpawnConfig.get()).booleanValue() || tag.m_128471_("hasInitial" + book.getRegistryName().toString())) continue;
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)GuideAPI.getStackFromBook(book));
                    tag.m_128379_("hasInitial" + book.getRegistryName().toString(), true);
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void renderOverlay(RenderGuiOverlayEvent.Pre event) {
        Multimap<Block, IInfoRenderer> bookRenderers;
        IGuideLinked linked;
        ResourceLocation entryKey;
        ItemStack heldStack;
        if (event.getOverlay() != VanillaGuiOverlay.CROSSHAIR.type()) {
            return;
        }
        HitResult rayTrace = Minecraft.m_91087_().f_91077_;
        if (rayTrace == null || rayTrace.m_6662_() != HitResult.Type.BLOCK) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        ItemStack held = ItemStack.f_41583_;
        Book book = null;
        for (InteractionHand hand : InteractionHand.values()) {
            heldStack = player.m_21120_(hand);
            if (!(heldStack.m_41720_() instanceof IGuideItem)) continue;
            held = heldStack;
            book = ((IGuideItem)heldStack.m_41720_()).getBook(heldStack);
            break;
        }
        if (book == null) {
            return;
        }
        BlockPos rayTracePos = ((BlockHitResult)rayTrace).m_82425_();
        BlockState state = world.m_8055_(rayTracePos);
        Component linkedEntry = null;
        heldStack = state.m_60734_();
        if (heldStack instanceof IGuideLinked && (entryKey = (linked = (IGuideLinked)heldStack).getLinkedEntry((Level)world, rayTracePos, (Player)player, held)) != null) {
            for (CategoryAbstract category : book.getCategoryList()) {
                if (!category.entries.containsKey(entryKey)) continue;
                linkedEntry = category.getEntry(entryKey).getName();
                break;
            }
        }
        GuiGraphics graphics = event.getGuiGraphics();
        if (linkedEntry != null) {
            Font fontRenderer = Minecraft.m_91087_().f_91062_;
            int drawX = Minecraft.m_91087_().m_91268_().m_85445_() / 2 + 10;
            int drawY = Minecraft.m_91087_().m_91268_().m_85446_() / 2 - 8;
            graphics.m_280480_(held, drawX, drawY);
            graphics.m_280614_(fontRenderer, (Component)(linkedEntry instanceof MutableComponent ? ((MutableComponent)linkedEntry).m_130940_(ChatFormatting.WHITE) : linkedEntry), drawX += 20, drawY -= 2, 0, true);
            graphics.m_280614_(fontRenderer, (Component)Component.m_237115_((String)"guideapi.text.linked.open").m_130944_(new ChatFormatting[]{ChatFormatting.WHITE, ChatFormatting.ITALIC}), drawX, drawY + 12, 0, true);
        }
        if (state.m_60734_() instanceof IInfoRenderer.Block) {
            IInfoRenderer infoRenderer = ((IInfoRenderer.Block)state.m_60734_()).getInfoRenderer(book, (Level)world, rayTracePos, state, rayTrace, (Player)player);
            if (book == ((IInfoRenderer.Block)state.m_60734_()).getBook() && infoRenderer != null) {
                infoRenderer.drawInformation(graphics, book, (Level)world, rayTracePos, state, rayTrace, (Player)player);
            }
        }
        if ((bookRenderers = GuideAPI.getInfoRenderers().get(book)) == null) {
            return;
        }
        Collection renderers = bookRenderers.get((Object)state.m_60734_());
        for (IInfoRenderer renderer : renderers) {
            renderer.drawInformation(graphics, book, (Level)world, rayTracePos, state, rayTrace, (Player)player);
        }
    }

    public static CompoundTag getModTag(Player player, String modName) {
        CompoundTag modTag;
        CompoundTag persistTag;
        CompoundTag tag = player.getPersistentData();
        if (tag.m_128441_("PlayerPersisted")) {
            persistTag = tag.m_128469_("PlayerPersisted");
        } else {
            persistTag = new CompoundTag();
            tag.m_128365_("PlayerPersisted", (Tag)persistTag);
        }
        if (persistTag.m_128441_(modName)) {
            modTag = persistTag.m_128469_(modName);
        } else {
            modTag = new CompoundTag();
            persistTag.m_128365_(modName, (Tag)modTag);
        }
        return modTag;
    }
}

