/*
 * Decompiled with CFR 0.152.
 */
package de.maxanier.guideapi.util;

import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import de.maxanier.guideapi.api.GuideAPI;
import de.maxanier.guideapi.api.impl.Book;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;

public class ReloadCommand {
    private static final DynamicCommandExceptionType BOOK_NOT_FOUND = new DynamicCommandExceptionType(id -> Component.m_237113_((String)("Book with registry id " + id + " not found")));
    private static final SimpleCommandExceptionType NOT_CLIENT = new SimpleCommandExceptionType((Message)new LiteralMessage("This command can only be used in singleplayer"));

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return Commands.m_82127_((String)"reload").then(Commands.m_82129_((String)"bookid", (ArgumentType)ResourceLocationArgument.m_106984_()).executes(context -> {
            if (FMLEnvironment.dist != Dist.CLIENT) {
                throw NOT_CLIENT.create();
            }
            ResourceLocation id = ResourceLocationArgument.m_107011_((CommandContext)context, (String)"bookid");
            Book b = GuideAPI.getBooks().get(id);
            if (b == null) {
                throw BOOK_NOT_FOUND.create((Object)id.toString());
            }
            b.forceInitializeContent();
            return 0;
        }));
    }
}

