/*
 * Decompiled with CFR 0.152.
 */
package terrablender.mixin;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Climate;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import terrablender.api.Region;
import terrablender.api.RegionType;
import terrablender.api.Regions;
import terrablender.worldgen.IExtendedParameterList;
import terrablender.worldgen.noise.Area;
import terrablender.worldgen.noise.LayeredNoiseUtil;

@Mixin(value={Climate.ParameterList.class})
public abstract class MixinParameterList<T>
implements IExtendedParameterList<T> {
    @Shadow
    @Final
    private List<Pair<Climate.ParameterPoint, T>> f_186846_;
    private boolean initialized = false;
    private boolean treesPopulated = false;
    private Area uniqueness;
    private Climate.RTree[] uniqueTrees;

    @Shadow
    public abstract T m_204252_(Climate.TargetPoint var1);

    @Override
    public void initializeForTerraBlender(RegistryAccess registryAccess, RegionType regionType, long seed) {
        if (this.initialized) {
            return;
        }
        this.uniqueness = LayeredNoiseUtil.uniqueness(registryAccess, regionType, seed);
        this.uniqueTrees = new Climate.RTree[Regions.getCount(regionType)];
        Registry biomeRegistry = registryAccess.m_175515_(Registries.f_256952_);
        for (Region region : Regions.get(regionType)) {
            int regionIndex = Regions.getIndex(regionType, region.getName());
            if (regionIndex == 0) {
                this.uniqueTrees[0] = Climate.RTree.m_186935_(this.f_186846_);
                continue;
            }
            ImmutableList.Builder builder = ImmutableList.builder();
            region.addBiomes((Registry<Biome>)biomeRegistry, pair -> {
                if (biomeRegistry.m_203636_((ResourceKey)pair.getSecond()).isPresent()) {
                    builder.add((Object)pair.mapSecond(arg_0 -> ((Registry)biomeRegistry).m_246971_(arg_0)));
                }
            });
            ImmutableList uniqueValues = builder.build();
            if (uniqueValues.isEmpty()) continue;
            this.uniqueTrees[regionIndex] = Climate.RTree.m_186935_((List)uniqueValues);
        }
        this.treesPopulated = true;
        this.initialized = true;
    }

    @Override
    public int getUniqueness(int x, int y, int z) {
        return this.uniqueness.get(x, z);
    }

    @Override
    public Climate.RTree getTree(int uniqueness) {
        return this.uniqueTrees[uniqueness];
    }

    @Override
    public int getTreeCount() {
        return this.uniqueTrees.length;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized && this.treesPopulated;
    }

    @Override
    public T findValuePositional(Climate.TargetPoint target, int x, int y, int z) {
        if (!this.initialized) {
            return this.m_204252_(target);
        }
        if (!this.treesPopulated) {
            throw new RuntimeException("Attempted to call findValuePositional whilst trees remain unpopulated!");
        }
        int uniqueness = this.getUniqueness(x, y, z);
        Holder biome = (Holder)this.getTree(uniqueness).m_186930_(target, Climate.RTree.Node::m_186959_);
        if (biome.m_203565_(Region.DEFERRED_PLACEHOLDER)) {
            return (T)this.uniqueTrees[0].m_186930_(target, Climate.RTree.Node::m_186959_);
        }
        return (T)biome;
    }
}

